/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.manager;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.configuration.ClusteredLockManagerConfiguration;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.lock.ClusteredLockImpl;
import org.infinispan.lock.logging.Log;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.function.SerializableBiFunction;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ClusteredLockManager", description="Component to manage clustered locks")
public class EmbeddedClusteredLockManager
implements ClusteredLockManager,
Lifecycle {
    public static final String OBJECT_NAME = "ClusteredLockManager";
    private static final Log log = (Log)LogFactory.getLog(EmbeddedClusteredLockManager.class, Log.class);
    public static final String FORCE_RELEASE = "forceRelease";
    public static final String REMOVE = "remove";
    public static final String IS_DEFINED = "isDefined";
    public static final String IS_LOCKED = "isLocked";
    private final ConcurrentHashMap<String, ClusteredLock> locks = new ConcurrentHashMap();
    private final ClusteredLockManagerConfiguration config;
    private volatile boolean started = false;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService scheduledExecutorService;
    private AdvancedCache<ClusteredLockKey, ClusteredLockValue> cache;

    public EmbeddedClusteredLockManager(ClusteredLockManagerConfiguration config) {
        this.config = config;
    }

    public void start() {
        if (log.isTraceEnabled()) {
            log.trace("Starting EmbeddedClusteredLockManager");
        }
        this.cache = this.cacheManager.getCache("org.infinispan.LOCKS").getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE});
        this.started = true;
    }

    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace("Stopping EmbeddedClusteredLockManager");
        }
        this.started = false;
        this.cache = null;
    }

    private AdvancedCache<ClusteredLockKey, ClusteredLockValue> cache() {
        if (!this.started) {
            throw new IllegalStateException("Component not running, cannot request the lock cache");
        }
        return this.cache;
    }

    @Override
    public boolean defineLock(String name) {
        ClusteredLockConfiguration configuration = new ClusteredLockConfiguration();
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] defineLock with default configuration has been called %s", name, configuration);
        }
        return this.defineLock(name, configuration);
    }

    @Override
    public boolean defineLock(String name, ClusteredLockConfiguration configuration) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] defineLock has been called %s", name, configuration);
        }
        ClusteredLockKey key = new ClusteredLockKey(ByteString.fromString((String)name));
        ClusteredLockValue clv = (ClusteredLockValue)this.cache().putIfAbsent((Object)key, (Object)ClusteredLockValue.INITIAL_STATE);
        this.locks.putIfAbsent(name, new ClusteredLockImpl(name, key, this.cache, this));
        return clv == null;
    }

    @Override
    public ClusteredLock get(String name) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] get has been called", name);
        }
        return this.locks.computeIfAbsent(name, this::createLock);
    }

    private ClusteredLockImpl createLock(String lockName) {
        ClusteredLockConfiguration configuration = this.getConfiguration(lockName);
        if (configuration == null) {
            throw new ClusteredLockException(String.format("Lock %s does not exist", lockName));
        }
        ClusteredLockKey key = new ClusteredLockKey(ByteString.fromString((String)lockName));
        this.cache().putIfAbsent((Object)key, (Object)ClusteredLockValue.INITIAL_STATE);
        ClusteredLockImpl lock = new ClusteredLockImpl(lockName, key, this.cache(), this);
        return lock;
    }

    @Override
    public ClusteredLockConfiguration getConfiguration(String name) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] getConfiguration has been called", name);
        }
        if (this.cache().containsKey((Object)new ClusteredLockKey(ByteString.fromString((String)name)))) {
            return new ClusteredLockConfiguration();
        }
        if (this.config.locks().containsKey(name)) {
            return new ClusteredLockConfiguration();
        }
        throw new ClusteredLockException(String.format("Lock %s does not exist", name));
    }

    @Override
    @ManagedOperation(description="Returns true if the lock is defined", displayName="Is Lock Defined", name="isDefined")
    public boolean isDefined(String name) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] isDefined has been called", name);
        }
        return this.cache().containsKey((Object)new ClusteredLockKey(ByteString.fromString((String)name)));
    }

    @Override
    public CompletableFuture<Boolean> remove(String name) {
        ClusteredLockImpl clusteredLock;
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] remove has been called", name);
        }
        if ((clusteredLock = (ClusteredLockImpl)this.locks.get(name)) != null) {
            clusteredLock.stop();
            this.locks.remove(name);
        }
        return this.cache().removeAsync((Object)new ClusteredLockKey(ByteString.fromString((String)name))).thenApply(Objects::nonNull);
    }

    @ManagedOperation(description="Removes the lock from the cluster. The lock has to be recreated to access next time.", displayName="Remove Clustered Lock", name="remove")
    public boolean removeSync(String name) {
        ClusteredLockImpl clusteredLock;
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] remove sync has been called", name);
        }
        if ((clusteredLock = (ClusteredLockImpl)this.locks.get(name)) != null) {
            clusteredLock.stop();
            this.locks.remove(name);
        }
        return this.cache().remove((Object)new ClusteredLockKey(ByteString.fromString((String)name))) != null;
    }

    @Override
    public CompletableFuture<Boolean> forceRelease(String name) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] forceRelease has been called", name);
        }
        ClusteredLockKey lockLey = new ClusteredLockKey(ByteString.fromString((String)name));
        return this.cache().computeIfPresentAsync((Object)lockLey, (SerializableBiFunction & Serializable)(k, v) -> ClusteredLockValue.INITIAL_STATE).thenApply(clv -> clv != null && clv.getState() == ClusteredLockState.RELEASED);
    }

    @ManagedOperation(description="Forces a release of the lock if such exist", displayName="Release Clustered Lock", name="forceRelease")
    public boolean forceReleaseSync(String name) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] forceRelease sync has been called", name);
        }
        return this.forceRelease(name).join();
    }

    @ManagedOperation(description="Returns true if the lock exists and is acquired", displayName="Is Locked", name="isLocked")
    public boolean isLockedSync(String name) {
        ClusteredLockValue clv;
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] isLocked sync has been called", name);
        }
        return (clv = (ClusteredLockValue)this.cache().get((Object)new ClusteredLockKey(ByteString.fromString((String)name)))) != null && clv.getState() == ClusteredLockState.ACQUIRED;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public String toString() {
        return "EmbeddedClusteredLockManager{address=" + String.valueOf(this.cacheManager.getAddress()) + ", locks=" + String.valueOf(this.locks) + "}";
    }
}

