/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public interface BooleanSupplier
extends java.util.function.BooleanSupplier {
    public static final BooleanSupplier TRUE = Boolean.TRUE::booleanValue;
    public static final BooleanSupplier FALSE = Boolean.FALSE::booleanValue;

    default public BooleanSupplier negate() {
        if (this == TRUE) {
            return FALSE;
        }
        if (this == FALSE) {
            return TRUE;
        }
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !BooleanSupplier.this.getAsBoolean();
            }
        };
    }

    default public Supplier<Boolean> boxed() {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return BooleanSupplier.this.getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    default public BooleanSupplier handle(final Predicate<RuntimeException> handler) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    return BooleanSupplier.this.getAsBoolean();
                }
                catch (RuntimeException e) {
                    return handler.test(e);
                }
            }
        };
    }

    public static BooleanSupplier of(boolean value) {
        return value ? TRUE : FALSE;
    }
}

