/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.DoubleSupplier;
import org.wildfly.clustering.function.IntSupplier;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.function.Supplier;

public interface LongSupplier
extends java.util.function.LongSupplier {
    public static final LongSupplier MINIMUM = LongSupplier.of(Long.MIN_VALUE);
    public static final LongSupplier ZERO = LongSupplier.of(0L);
    public static final LongSupplier MAXIMUM = LongSupplier.of(Long.MAX_VALUE);

    default public Runnable thenAccept(final LongConsumer consumer) {
        return new Runnable(){

            @Override
            public void run() {
                consumer.accept(LongSupplier.this.getAsLong());
            }
        };
    }

    default public <V> Supplier<V> thenApply(final LongFunction<V> function) {
        return new Supplier<V>(){

            @Override
            public V get() {
                return function.apply(LongSupplier.this.getAsLong());
            }
        };
    }

    default public DoubleSupplier thenApplyAsDouble(final LongToDoubleFunction function) {
        return new DoubleSupplier(){

            @Override
            public double getAsDouble() {
                return function.applyAsDouble(LongSupplier.this.getAsLong());
            }
        };
    }

    default public IntSupplier thenApplyAsInt(final LongToIntFunction function) {
        return new IntSupplier(){

            @Override
            public int getAsInt() {
                return function.applyAsInt(LongSupplier.this.getAsLong());
            }
        };
    }

    default public LongSupplier thenApplyAsLong(final LongUnaryOperator operator) {
        return new LongSupplier(){

            @Override
            public long getAsLong() {
                return operator.applyAsLong(LongSupplier.this.getAsLong());
            }
        };
    }

    default public BooleanSupplier thenTest(final LongPredicate predicate) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return predicate.test(LongSupplier.this.getAsLong());
            }
        };
    }

    default public Supplier<Long> boxed() {
        return this.thenApply(Long::valueOf);
    }

    default public LongSupplier handle(final ToLongFunction<RuntimeException> handler) {
        return new LongSupplier(){

            @Override
            public long getAsLong() {
                try {
                    return LongSupplier.this.getAsLong();
                }
                catch (RuntimeException e) {
                    return handler.applyAsLong(e);
                }
            }
        };
    }

    public static LongSupplier of(final long value) {
        return new LongSupplier(){

            @Override
            public long getAsLong() {
                return value;
            }
        };
    }
}

