/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;

public abstract class DiscardAttributesTransformer
implements OperationTransformer,
ResourceTransformer {
    public static final DiscardApprover LENIENT_DISCARD_APPROVER = new DiscardApprover(){

        @Override
        public boolean isResourceDiscardAllowed(TransformationContext context, PathAddress address, Resource resource) {
            return true;
        }

        @Override
        public boolean isOperationDiscardAllowed(TransformationContext context, PathAddress address, ModelNode operation) {
            return true;
        }
    };
    private final DiscardApprover discardApprover;
    private final Set<String> attributeNames;
    private final OperationTransformer writeAttributeTransformer;
    private final OperationTransformer undefineAttributeTransformer;

    protected DiscardAttributesTransformer(DiscardApprover discardApprover, AttributeDefinition ... attributes) {
        this(discardApprover, DiscardAttributesTransformer.namesFromDefinitions(attributes));
    }

    private static Set<String> namesFromDefinitions(AttributeDefinition ... attributes) {
        HashSet<String> names = new HashSet<String>();
        for (AttributeDefinition def : attributes) {
            names.add(def.getName());
        }
        return names;
    }

    protected DiscardAttributesTransformer(DiscardApprover discardApprover, String ... attributeNames) {
        this(discardApprover, new HashSet<String>(Arrays.asList(attributeNames)));
    }

    public DiscardAttributesTransformer(DiscardApprover discardApprover, Set<String> attributeNames) {
        this.undefineAttributeTransformer = this.writeAttributeTransformer = new WriteAttributeTransformer();
        assert (discardApprover != null) : "discardApprover is null";
        assert (attributeNames != null) : "attributeNames is null";
        this.attributeNames = attributeNames;
        this.discardApprover = discardApprover;
    }

    public OperationTransformer getWriteAttributeTransformer() {
        return this.writeAttributeTransformer;
    }

    public OperationTransformer getUndefineAttributeTransformer() {
        return this.undefineAttributeTransformer;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        boolean allowDiscard = this.discardApprover.isOperationDiscardAllowed(context, address, operation);
        ModelNode transformedOperation = allowDiscard ? this.transformInternal(operation.clone()) : operation;
        return new OperationTransformer.TransformedOperation(transformedOperation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        if (this.discardApprover.isResourceDiscardAllowed(context, address, resource)) {
            this.transformInternal(resource.getModel());
        }
    }

    private ModelNode transformInternal(ModelNode model) {
        for (String attr : this.attributeNames) {
            model.remove(attr);
        }
        return model;
    }

    public static interface DiscardApprover {
        public boolean isResourceDiscardAllowed(TransformationContext var1, PathAddress var2, Resource var3);

        public boolean isOperationDiscardAllowed(TransformationContext var1, PathAddress var2, ModelNode var3);
    }

    private class WriteAttributeTransformer
    implements OperationTransformer {
        private WriteAttributeTransformer() {
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            if (DiscardAttributesTransformer.this.attributeNames.contains(operation.get("name").asString()) && DiscardAttributesTransformer.this.discardApprover.isOperationDiscardAllowed(context, address, operation)) {
                return OperationTransformer.DISCARD.transformOperation(context, address, operation);
            }
            return OperationTransformer.DEFAULT.transformOperation(context, address, operation);
        }
    }

    public static class AttributeValueDiscardApprover
    implements DiscardApprover {
        private final String attributeName;
        private final ModelNode approvedValue;
        private final boolean allowUndefined;

        public AttributeValueDiscardApprover(String attributeName, ModelNode approvedValue, boolean allowUndefined) {
            this.attributeName = attributeName;
            this.approvedValue = approvedValue;
            this.allowUndefined = allowUndefined;
        }

        @Override
        public boolean isResourceDiscardAllowed(TransformationContext context, PathAddress address, Resource resource) {
            return this.isDiscardAllowed(resource.getModel());
        }

        @Override
        public boolean isOperationDiscardAllowed(TransformationContext context, PathAddress address, ModelNode operation) {
            String opName = operation.require("operation").asString();
            if ("add".equals(opName)) {
                return this.isDiscardAllowed(operation);
            }
            if ("write-attribute".equals(opName)) {
                String attr = operation.require("name").asString();
                if (attr.equals(this.attributeName)) {
                    ModelNode value = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
                    ModelNode mockModel = new ModelNode();
                    mockModel.get(this.attributeName).set(value);
                    return this.isDiscardAllowed(mockModel);
                }
                return this.isDiscardAllowed(context.readResource(PathAddress.EMPTY_ADDRESS).getModel());
            }
            if ("undefine-attribute".equals(opName)) {
                String attr = operation.require("name").asString();
                if (attr.equals(this.attributeName)) {
                    ModelNode mockModel = new ModelNode();
                    mockModel.get(this.attributeName);
                    return this.isDiscardAllowed(mockModel);
                }
                return this.isDiscardAllowed(context.readResource(PathAddress.EMPTY_ADDRESS).getModel());
            }
            throw new IllegalStateException();
        }

        private boolean isDiscardAllowed(ModelNode modelNode) {
            if (modelNode.hasDefined(this.attributeName)) {
                return this.approvedValue.equals(modelNode.get(this.attributeName));
            }
            return this.allowUndefined;
        }
    }
}

