/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.validation.ValidatorFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.sql.DataSource;
import org.jboss.as.jpa.beanmanager.BeanManagerAfterDeploymentValidation;
import org.jboss.as.jpa.beanmanager.IntegrationWithCDIBagImpl;
import org.jboss.as.jpa.beanmanager.ProxyBeanManager;
import org.jboss.as.jpa.classloader.TempClassLoaderFactoryImpl;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.service.PhaseOnePersistenceUnitServiceImpl;
import org.jboss.as.jpa.spi.PersistenceUnitService;
import org.jboss.as.jpa.subsystem.PersistenceUnitRegistryImpl;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jipijapa.plugin.spi.EntityManagerFactoryBuilder;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderIntegratorAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.TempClassLoaderFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class PersistenceUnitServiceImpl
implements Service<PersistenceUnitService>,
PersistenceUnitService {
    private final InjectedValue<DataSource> jtaDataSource = new InjectedValue();
    private final InjectedValue<DataSource> nonJtaDataSource = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final InjectedValue<BeanManager> beanManagerInjector = new InjectedValue();
    private final InjectedValue<PhaseOnePersistenceUnitServiceImpl> phaseOnePersistenceUnitServiceInjectedValue = new InjectedValue();
    private static final String CDI_BEAN_MANAGER = "jakarta.persistence.bean.manager";
    private static final String VALIDATOR_FACTORY = "jakarta.persistence.validation.factory";
    private final Map properties;
    private final PersistenceProviderAdaptor persistenceProviderAdaptor;
    private final List<PersistenceProviderIntegratorAdaptor> persistenceProviderIntegratorAdaptors;
    private final PersistenceProvider persistenceProvider;
    private final PersistenceUnitMetadata pu;
    private final ClassLoader classLoader;
    private final PersistenceUnitRegistryImpl persistenceUnitRegistry;
    private final ServiceName deploymentUnitServiceName;
    private final ValidatorFactory validatorFactory;
    private final BeanManagerAfterDeploymentValidation beanManagerAfterDeploymentValidation;
    private volatile EntityManagerFactory entityManagerFactory;
    private volatile ProxyBeanManager proxyBeanManager;
    private final SetupAction javaNamespaceSetup;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final TransactionManager transactionManager;
    private final IntegrationWithCDIBagImpl integrationWithCDIBag;

    public PersistenceUnitServiceImpl(Map properties, ClassLoader classLoader, PersistenceUnitMetadata pu, PersistenceProviderAdaptor persistenceProviderAdaptor, List<PersistenceProviderIntegratorAdaptor> persistenceProviderIntegratorAdaptors, PersistenceProvider persistenceProvider, PersistenceUnitRegistryImpl persistenceUnitRegistry, ServiceName deploymentUnitServiceName, ValidatorFactory validatorFactory, SetupAction javaNamespaceSetup, BeanManagerAfterDeploymentValidation beanManagerAfterDeploymentValidation, TransactionSynchronizationRegistry transactionSynchronizationRegistry, TransactionManager transactionManager, IntegrationWithCDIBagImpl integrationWithCDIBag) {
        this.properties = properties;
        this.pu = pu;
        this.persistenceProviderAdaptor = persistenceProviderAdaptor;
        this.persistenceProviderIntegratorAdaptors = persistenceProviderIntegratorAdaptors;
        this.persistenceProvider = persistenceProvider;
        this.classLoader = classLoader;
        this.persistenceUnitRegistry = persistenceUnitRegistry;
        this.deploymentUnitServiceName = deploymentUnitServiceName;
        this.validatorFactory = validatorFactory;
        this.javaNamespaceSetup = javaNamespaceSetup;
        this.beanManagerAfterDeploymentValidation = beanManagerAfterDeploymentValidation;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.transactionManager = transactionManager;
        this.integrationWithCDIBag = integrationWithCDIBag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        ExecutorService executor = (ExecutorService)this.executorInjector.getValue();
        final AccessControlContext accessControlContext = (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
        Runnable task = new Runnable(){

            @Override
            public void run() {
                PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(PersistenceUnitServiceImpl.this.classLoader);
                        if (PersistenceUnitServiceImpl.this.javaNamespaceSetup != null) {
                            PersistenceUnitServiceImpl.this.javaNamespaceSetup.setup(Collections.emptyMap());
                        }
                        try {
                            PhaseOnePersistenceUnitServiceImpl phaseOnePersistenceUnitService = (PhaseOnePersistenceUnitServiceImpl)PersistenceUnitServiceImpl.this.phaseOnePersistenceUnitServiceInjectedValue.getOptionalValue();
                            WritableServiceBasedNamingStore.pushOwner((ServiceName)PersistenceUnitServiceImpl.this.deploymentUnitServiceName);
                            Object wrapperBeanManagerLifeCycle = null;
                            if (PersistenceUnitServiceImpl.this.validatorFactory != null) {
                                PersistenceUnitServiceImpl.this.properties.put(PersistenceUnitServiceImpl.VALIDATOR_FACTORY, PersistenceUnitServiceImpl.this.validatorFactory);
                            }
                            if (phaseOnePersistenceUnitService != null) {
                                JpaLogger.ROOT_LOGGER.startingPersistenceUnitService(2, PersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                                phaseOnePersistenceUnitService.setSecondPhaseStarted(true);
                                if (PersistenceUnitServiceImpl.this.beanManagerInjector.getOptionalValue() != null) {
                                    wrapperBeanManagerLifeCycle = phaseOnePersistenceUnitService.getBeanManagerLifeCycle();
                                    PersistenceUnitServiceImpl.this.proxyBeanManager = phaseOnePersistenceUnitService.getBeanManager();
                                    PersistenceUnitServiceImpl.this.proxyBeanManager.setDelegate((BeanManager)PersistenceUnitServiceImpl.this.beanManagerInjector.getOptionalValue());
                                }
                                EntityManagerFactoryBuilder emfBuilder = phaseOnePersistenceUnitService.getEntityManagerFactoryBuilder();
                                if (PersistenceUnitServiceImpl.this.validatorFactory != null) {
                                    emfBuilder.withValidatorFactory((Object)PersistenceUnitServiceImpl.this.validatorFactory);
                                }
                                PersistenceUnitServiceImpl.this.entityManagerFactory = emfBuilder.build();
                                if (phaseOnePersistenceUnitService.getIntegrationWithCDIBag() != null) {
                                    phaseOnePersistenceUnitService.getIntegrationWithCDIBag().setEntityManagerFactory(PersistenceUnitServiceImpl.this.entityManagerFactory);
                                    phaseOnePersistenceUnitService.getIntegrationWithCDIBag().setTransactionManager(PersistenceUnitServiceImpl.this.transactionManager);
                                    phaseOnePersistenceUnitService.getIntegrationWithCDIBag().setTransactionSynchronizationRegistry(PersistenceUnitServiceImpl.this.transactionSynchronizationRegistry);
                                }
                            } else {
                                JpaLogger.ROOT_LOGGER.startingService("Persistence Unit", PersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                                PersistenceUnitServiceImpl.this.pu.setTempClassLoaderFactory((TempClassLoaderFactory)new TempClassLoaderFactoryImpl(PersistenceUnitServiceImpl.this.classLoader));
                                PersistenceUnitServiceImpl.this.pu.setJtaDataSource((DataSource)PersistenceUnitServiceImpl.this.jtaDataSource.getOptionalValue());
                                PersistenceUnitServiceImpl.this.pu.setNonJtaDataSource((DataSource)PersistenceUnitServiceImpl.this.nonJtaDataSource.getOptionalValue());
                                if (PersistenceUnitServiceImpl.this.beanManagerInjector.getOptionalValue() != null) {
                                    PersistenceUnitServiceImpl.this.proxyBeanManager = new ProxyBeanManager();
                                    PersistenceUnitServiceImpl.this.proxyBeanManager.setDelegate((BeanManager)PersistenceUnitServiceImpl.this.beanManagerInjector.getOptionalValue());
                                    wrapperBeanManagerLifeCycle = PersistenceUnitServiceImpl.this.persistenceProviderAdaptor.beanManagerLifeCycle((BeanManager)PersistenceUnitServiceImpl.this.proxyBeanManager);
                                    if (wrapperBeanManagerLifeCycle != null) {
                                        PersistenceUnitServiceImpl.this.properties.put(PersistenceUnitServiceImpl.CDI_BEAN_MANAGER, wrapperBeanManagerLifeCycle);
                                    } else {
                                        PersistenceUnitServiceImpl.this.properties.put(PersistenceUnitServiceImpl.CDI_BEAN_MANAGER, PersistenceUnitServiceImpl.this.proxyBeanManager);
                                    }
                                }
                                PersistenceUnitServiceImpl.this.entityManagerFactory = PersistenceUnitServiceImpl.this.createContainerEntityManagerFactory();
                                if (PersistenceUnitServiceImpl.this.integrationWithCDIBag != null) {
                                    PersistenceUnitServiceImpl.this.integrationWithCDIBag.setEntityManagerFactory(PersistenceUnitServiceImpl.this.entityManagerFactory);
                                }
                            }
                            PersistenceUnitServiceImpl.this.persistenceUnitRegistry.add(PersistenceUnitServiceImpl.this.getScopedPersistenceUnitName(), PersistenceUnitServiceImpl.this.getValue());
                            if (wrapperBeanManagerLifeCycle != null) {
                                PersistenceUnitServiceImpl.this.beanManagerAfterDeploymentValidation.register(PersistenceUnitServiceImpl.this.persistenceProviderAdaptor, wrapperBeanManagerLifeCycle);
                            }
                            if (PersistenceUnitServiceImpl.this.proxyBeanManager != null && PersistenceUnitServiceImpl.this.proxyBeanManager.delegate() != null) {
                                this.createCDIBeansForPersistence(PersistenceUnitServiceImpl.this.proxyBeanManager.delegate(), PersistenceUnitServiceImpl.this.entityManagerFactory, PersistenceUnitServiceImpl.this.pu, PersistenceUnitServiceImpl.this.classLoader);
                            }
                            context.complete();
                        }
                        catch (Throwable t) {
                            context.failed(new StartException(t));
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                            PersistenceUnitServiceImpl.this.pu.setTempClassLoaderFactory(null);
                            WritableServiceBasedNamingStore.popOwner();
                            if (PersistenceUnitServiceImpl.this.javaNamespaceSetup != null) {
                                PersistenceUnitServiceImpl.this.javaNamespaceSetup.teardown(Collections.emptyMap());
                            }
                        }
                        return null;
                    }

                    private void createCDIBeansForPersistence(BeanManager beanManager, EntityManagerFactory entityManagerFactory, PersistenceUnitMetadata pu, ClassLoader classLoader) {
                    }
                };
                WildFlySecurityManager.doChecked((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext);
            }
        };
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        ExecutorService executor = (ExecutorService)this.executorInjector.getValue();
        final AccessControlContext accessControlContext = (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
        Runnable task = new Runnable(){

            @Override
            public void run() {
                PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void run() {
                        1 var2_2;
                        block22: {
                            if (PersistenceUnitServiceImpl.this.phaseOnePersistenceUnitServiceInjectedValue.getOptionalValue() != null) {
                                JpaLogger.ROOT_LOGGER.stoppingPersistenceUnitService(2, PersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                            } else {
                                JpaLogger.ROOT_LOGGER.stoppingService("Persistence Unit", PersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                            }
                            ClassLoader old = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(PersistenceUnitServiceImpl.this.classLoader);
                            if (PersistenceUnitServiceImpl.this.javaNamespaceSetup != null) {
                                PersistenceUnitServiceImpl.this.javaNamespaceSetup.setup(Collections.emptyMap());
                            }
                            try {
                                if (PersistenceUnitServiceImpl.this.entityManagerFactory == null) break block22;
                                var2_2 = this;
                                synchronized (var2_2) {
                                    if (PersistenceUnitServiceImpl.this.entityManagerFactory != null) {
                                        WritableServiceBasedNamingStore.pushOwner((ServiceName)PersistenceUnitServiceImpl.this.deploymentUnitServiceName);
                                        try {
                                            if (PersistenceUnitServiceImpl.this.entityManagerFactory.isOpen()) {
                                                PersistenceUnitServiceImpl.this.entityManagerFactory.close();
                                            }
                                        }
                                        catch (Throwable t) {
                                            JpaLogger.ROOT_LOGGER.failedToStopPUService(t, PersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                                        }
                                        finally {
                                            PersistenceUnitServiceImpl.this.entityManagerFactory = null;
                                            PersistenceUnitServiceImpl.this.pu.setTempClassLoaderFactory(null);
                                            WritableServiceBasedNamingStore.popOwner();
                                            PersistenceUnitServiceImpl.this.persistenceUnitRegistry.remove(PersistenceUnitServiceImpl.this.getScopedPersistenceUnitName());
                                        }
                                    }
                                }
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(old);
                                if (PersistenceUnitServiceImpl.this.javaNamespaceSetup != null) {
                                    PersistenceUnitServiceImpl.this.javaNamespaceSetup.teardown(Collections.emptyMap());
                                }
                            }
                        }
                        if (PersistenceUnitServiceImpl.this.proxyBeanManager != null) {
                            var2_2 = this;
                            synchronized (var2_2) {
                                if (PersistenceUnitServiceImpl.this.proxyBeanManager != null) {
                                    PersistenceUnitServiceImpl.this.proxyBeanManager.setDelegate(null);
                                    PersistenceUnitServiceImpl.this.proxyBeanManager = null;
                                }
                            }
                        }
                        context.complete();
                        return null;
                    }
                };
                WildFlySecurityManager.doChecked((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext);
            }
        };
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }

    public PersistenceUnitServiceImpl getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public String getScopedPersistenceUnitName() {
        return this.pu.getScopedPersistenceUnitName();
    }

    public Injector<DataSource> getJtaDataSourceInjector() {
        return this.jtaDataSource;
    }

    public Injector<DataSource> getNonJtaDataSourceInjector() {
        return this.nonJtaDataSource;
    }

    public Injector<BeanManager> getBeanManagerInjector() {
        return this.beanManagerInjector;
    }

    public static ServiceName getPUServiceName(PersistenceUnitMetadata pu) {
        return JPAServiceNames.getPUServiceName(pu.getScopedPersistenceUnitName());
    }

    public static ServiceName getPUServiceName(String scopedPersistenceUnitName) {
        return JPAServiceNames.getPUServiceName(scopedPersistenceUnitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createContainerEntityManagerFactory() {
        this.persistenceProviderAdaptor.beforeCreateContainerEntityManagerFactory(this.pu);
        try {
            JpaLogger.ROOT_LOGGER.tracef("calling createContainerEntityManagerFactory for pu=%s with integration properties=%s, application properties=%s", this.pu.getScopedPersistenceUnitName(), this.properties, this.pu.getProperties());
            EntityManagerFactory entityManagerFactory = this.persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.pu, this.properties);
            return entityManagerFactory;
        }
        finally {
            this.persistenceProviderAdaptor.afterCreateContainerEntityManagerFactory(this.pu);
            for (PersistenceProviderIntegratorAdaptor adaptor : this.persistenceProviderIntegratorAdaptors) {
                adaptor.afterCreateContainerEntityManagerFactory(this.pu);
            }
        }
    }

    public Injector<PhaseOnePersistenceUnitServiceImpl> getPhaseOnePersistenceUnitServiceImplInjector() {
        return this.phaseOnePersistenceUnitServiceInjectedValue;
    }
}

