/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.executor.RuntimeOperation;
import org.wildfly.subsystem.resource.executor.RuntimeOperationExecutor;
import org.wildfly.subsystem.resource.executor.RuntimeOperationFunction;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class BackupSiteOperationExecutor
implements RuntimeOperationExecutor<Map.Entry<String, XSiteAdminOperations>> {
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    public BackupSiteOperationExecutor(FunctionExecutorRegistry<Cache<?, ?>> executors) {
        this.executors = executors;
    }

    public ModelNode execute(final OperationContext context, ModelNode operation, RuntimeOperation<Map.Entry<String, XSiteAdminOperations>> executable) throws OperationFailedException {
        PathAddress cacheAddress = context.getCurrentAddress().getParent().getParent();
        String containerName = cacheAddress.getParent().getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        Function mapper = new Function<Cache<?, ?>, Map.Entry<String, XSiteAdminOperations>>(){

            @Override
            public Map.Entry<String, XSiteAdminOperations> apply(Cache<?, ?> cache) {
                String site = context.getCurrentAddressValue();
                return new AbstractMap.SimpleImmutableEntry<String, XSiteAdminOperations>(site, (XSiteAdminOperations)ComponentRegistry.componentOf((Cache)cache.getAdvancedCache(), XSiteAdminOperations.class));
            }
        };
        FunctionExecutor executor = this.executors.getExecutor((Object)ServiceDependency.on((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE, (String)containerName, (String)cacheName));
        return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new RuntimeOperationFunction((ExpressionResolver)context, operation, mapper, executable)) : null;
    }
}

