/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedBindingRegistry;
import org.jboss.as.network.ManagedDatagramSocketBinding;
import org.jboss.as.network.ManagedMulticastSocketBinding;
import org.jboss.as.network.ManagedServerSocketBinding;
import org.jboss.as.network.ManagedServerSocketFactory;
import org.jboss.as.network.ManagedSocketBinding;
import org.jboss.as.network.ManagedSocketFactory;
import org.jboss.as.network.SocketBindingManager;
import org.wildfly.common.Assert;

public abstract class SocketBindingManagerImpl
implements SocketBindingManager {
    private final ManagedSocketFactory socketFactory = new ManagedSocketFactoryImpl();
    private final ManagedServerSocketFactory serverSocketFactory = new ManagedServerSocketFactoryImpl();
    private final SocketBindingManager.NamedManagedBindingRegistry namedRegistry = new NamedRegistryImpl();
    private final SocketBindingManager.UnnamedBindingRegistry unnamedRegistry = new UnnamedRegistryImpl();

    @Override
    public ManagedServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    @Override
    public ManagedSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public DatagramSocket createDatagramSocket(String name) throws SocketException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return new ManagedDatagramSocketBinding(name, this.namedRegistry, null);
    }

    @Override
    public DatagramSocket createDatagramSocket() throws SocketException {
        return new ManagedDatagramSocketBinding(null, this.unnamedRegistry, null);
    }

    @Override
    public DatagramSocket createDatagramSocket(String name, SocketAddress address) throws SocketException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"address", (Object)address);
        return new ManagedDatagramSocketBinding(name, this.namedRegistry, address);
    }

    @Override
    public DatagramSocket createDatagramSocket(SocketAddress address) throws SocketException {
        Assert.checkNotNullParam((String)"address", (Object)address);
        return new ManagedDatagramSocketBinding(null, this.unnamedRegistry, address);
    }

    @Override
    public MulticastSocket createMulticastSocket(String name) throws IOException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return ManagedMulticastSocketBinding.create(name, this.namedRegistry, null);
    }

    @Override
    public MulticastSocket createMulticastSocket() throws IOException {
        return ManagedMulticastSocketBinding.create(null, this.unnamedRegistry, null);
    }

    @Override
    public MulticastSocket createMulticastSocket(String name, SocketAddress address) throws IOException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"address", (Object)address);
        return ManagedMulticastSocketBinding.create(name, this.namedRegistry, address);
    }

    @Override
    public MulticastSocket createMulticastSocket(SocketAddress address) throws IOException {
        Assert.checkNotNullParam((String)"address", (Object)address);
        return ManagedMulticastSocketBinding.create(null, this.unnamedRegistry, address);
    }

    @Override
    public SocketBindingManager.NamedManagedBindingRegistry getNamedRegistry() {
        return this.namedRegistry;
    }

    @Override
    public SocketBindingManager.UnnamedBindingRegistry getUnnamedRegistry() {
        return this.unnamedRegistry;
    }

    private class ManagedSocketFactoryImpl
    extends ManagedSocketFactory {
        private ManagedSocketFactoryImpl() {
        }

        @Override
        public Socket createSocket() {
            return new ManagedSocketBinding(SocketBindingManagerImpl.this.unnamedRegistry);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.createSocket(InetAddress.getByName(host), port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket socket = this.createSocket();
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.createSocket(InetAddress.getByName(host), port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.createSocket();
            socket.bind(new InetSocketAddress(localAddress, localPort));
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }

        @Override
        public Socket createSocket(String name) {
            return new ManagedSocketBinding(name, SocketBindingManagerImpl.this.namedRegistry);
        }

        @Override
        public Socket createSocket(String name, String host, int port) throws IOException {
            return this.createSocket(name, InetAddress.getByName(host), port);
        }

        @Override
        public Socket createSocket(String name, InetAddress host, int port) throws IOException {
            Socket socket = this.createSocket(name);
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }

        @Override
        public Socket createSocket(String name, String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.createSocket(name, InetAddress.getByName(host), port, localHost, localPort);
        }

        @Override
        public Socket createSocket(String name, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.createSocket(name);
            socket.bind(new InetSocketAddress(localAddress, localPort));
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }
    }

    private class ManagedServerSocketFactoryImpl
    extends ManagedServerSocketFactory {
        private ManagedServerSocketFactoryImpl() {
        }

        @Override
        public ServerSocket createServerSocket(String name) throws IOException {
            return new ManagedServerSocketBinding(name, SocketBindingManagerImpl.this);
        }

        @Override
        public ServerSocket createServerSocket() throws IOException {
            return this.createServerSocket(null);
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.createServerSocket(null, port);
        }

        @Override
        public ServerSocket createServerSocket(String name, int port) throws IOException {
            ServerSocket serverSocket = this.createServerSocket(name);
            serverSocket.bind(new InetSocketAddress(port));
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.createServerSocket(null, port, backlog);
        }

        @Override
        public ServerSocket createServerSocket(String name, int port, int backlog) throws IOException {
            ServerSocket serverSocket = this.createServerSocket(name);
            serverSocket.bind(new InetSocketAddress(port), backlog);
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            return this.createServerSocket(null, port, backlog, ifAddress);
        }

        @Override
        public ServerSocket createServerSocket(String name, int port, int backlog, InetAddress ifAddress) throws IOException {
            ServerSocket serverSocket = this.createServerSocket(name);
            serverSocket.bind(new InetSocketAddress(ifAddress, port), backlog);
            return serverSocket;
        }
    }

    private static final class NamedRegistryImpl
    implements SocketBindingManager.NamedManagedBindingRegistry {
        private final Map<String, ManagedBinding> bindings = new ConcurrentHashMap<String, ManagedBinding>();

        private NamedRegistryImpl() {
        }

        @Override
        public ManagedBinding getManagedBinding(String name) {
            return this.bindings.get(name);
        }

        @Override
        public boolean isRegistered(String name) {
            return this.bindings.containsKey(name);
        }

        @Override
        public void registerBinding(ManagedBinding binding) {
            String name = binding.getSocketBindingName();
            if (name == null) {
                throw new IllegalStateException();
            }
            this.bindings.put(name, new WrappedManagedBinding(binding, this));
        }

        @Override
        public void unregisterBinding(ManagedBinding binding) {
            String name = binding.getSocketBindingName();
            if (name == null) {
                throw new IllegalStateException();
            }
            this.unregisterBinding(name);
        }

        @Override
        public Collection<ManagedBinding> listActiveBindings() {
            return new HashSet<ManagedBinding>(this.bindings.values());
        }

        @Override
        public Closeable registerSocket(String name, Socket socket) {
            WrappedManagedSocket binding = new WrappedManagedSocket(name, socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(String name, ServerSocket socket) {
            WrappedManagedServerSocket binding = new WrappedManagedServerSocket(name, socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(String name, DatagramSocket socket) {
            WrappedManagedDatagramSocket binding = new WrappedManagedDatagramSocket(name, socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(String name, SocketChannel channel) {
            NetworkChannelManagedBinding binding = new NetworkChannelManagedBinding(name, channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(String name, ServerSocketChannel channel) {
            NetworkChannelManagedBinding binding = new NetworkChannelManagedBinding(name, channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(String name, DatagramChannel channel) {
            NetworkChannelManagedBinding binding = new NetworkChannelManagedBinding(name, channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public void unregisterBinding(String name) {
            if (name == null) {
                return;
            }
            this.bindings.remove(name);
        }
    }

    private static final class UnnamedRegistryImpl
    implements SocketBindingManager.UnnamedBindingRegistry {
        private static final Object VALUE = new Object();
        private final Map<WrapperBinding, Object> bindings = new ConcurrentHashMap<WrapperBinding, Object>();

        private UnnamedRegistryImpl() {
        }

        @Override
        public void registerBinding(ManagedBinding binding) {
            this.bindings.put(new WrappedManagedBinding(binding, this), VALUE);
        }

        @Override
        public void unregisterBinding(ManagedBinding binding) {
            if (binding != null) {
                WrapperBinding toRemove = binding instanceof WrapperBinding ? (WrapperBinding)binding : new WrappedManagedBinding(binding, this);
                this.bindings.remove(toRemove);
            }
        }

        @Override
        public Collection<ManagedBinding> listActiveBindings() {
            return new HashSet<ManagedBinding>(this.bindings.keySet());
        }

        @Override
        public Closeable registerSocket(Socket socket) {
            WrappedManagedSocket binding = new WrappedManagedSocket(socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(ServerSocket socket) {
            WrappedManagedServerSocket binding = new WrappedManagedServerSocket(socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerSocket(DatagramSocket socket) {
            WrappedManagedDatagramSocket binding = new WrappedManagedDatagramSocket(socket, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(SocketChannel channel) {
            NetworkChannelManagedBinding binding = new NetworkChannelManagedBinding(channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(ServerSocketChannel channel) {
            NetworkChannelManagedBinding binding = new NetworkChannelManagedBinding(channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public Closeable registerChannel(DatagramChannel channel) {
            NetworkChannelManagedBinding binding = new NetworkChannelManagedBinding(channel, this);
            this.registerBinding(binding);
            return binding;
        }

        @Override
        public void unregisterSocket(Socket socket) {
            this.bindings.remove(new WrappedManagedSocket(socket, this));
        }

        @Override
        public void unregisterSocket(ServerSocket socket) {
            this.bindings.remove(new WrappedManagedServerSocket(socket, this));
        }

        @Override
        public void unregisterSocket(DatagramSocket socket) {
            this.bindings.remove(new WrappedManagedDatagramSocket(socket, this));
        }

        @Override
        public void unregisterChannel(SocketChannel channel) {
            NetworkChannelManagedBinding wrapper = new NetworkChannelManagedBinding(channel, this);
            this.bindings.remove(wrapper);
        }

        @Override
        public void unregisterChannel(ServerSocketChannel channel) {
            NetworkChannelManagedBinding wrapper = new NetworkChannelManagedBinding(channel, this);
            this.bindings.remove(wrapper);
        }

        @Override
        public void unregisterChannel(DatagramChannel channel) {
            NetworkChannelManagedBinding wrapper = new NetworkChannelManagedBinding(channel, this);
            this.bindings.remove(wrapper);
        }
    }

    private static class WrappedManagedServerSocket
    extends WrapperBinding {
        private final String name;
        private final ServerSocket socket;
        private final ManagedBindingRegistry registry;

        public WrappedManagedServerSocket(ServerSocket socket, ManagedBindingRegistry registry) {
            this(null, socket, registry);
        }

        public WrappedManagedServerSocket(String name, ServerSocket socket, ManagedBindingRegistry registry) {
            assert (socket != null);
            this.name = name;
            this.socket = socket;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.registry.unregisterBinding(this);
            }
            finally {
                this.socket.close();
            }
        }

        @Override
        Object getWrappedObject() {
            return this.socket;
        }
    }

    private static class WrappedManagedSocket
    extends WrapperBinding {
        private final String name;
        private final Socket socket;
        private final ManagedBindingRegistry registry;

        public WrappedManagedSocket(Socket socket, ManagedBindingRegistry registry) {
            this(null, socket, registry);
        }

        public WrappedManagedSocket(String name, Socket socket, ManagedBindingRegistry registry) {
            assert (socket != null);
            this.name = name;
            this.socket = socket;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.registry.unregisterBinding(this);
            }
            finally {
                this.socket.close();
            }
        }

        @Override
        Object getWrappedObject() {
            return this.socket;
        }
    }

    private static class WrappedManagedBinding
    extends WrapperBinding {
        private final ManagedBinding wrapped;
        private final ManagedBindingRegistry registry;

        public WrappedManagedBinding(ManagedBinding wrapped, ManagedBindingRegistry registry) {
            assert (wrapped != null);
            this.wrapped = wrapped;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.wrapped.getSocketBindingName();
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return this.wrapped.getBindAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.registry.unregisterBinding(this);
            }
            finally {
                this.wrapped.close();
            }
        }

        @Override
        Object getWrappedObject() {
            return this.wrapped;
        }
    }

    private static class WrappedManagedDatagramSocket
    extends WrapperBinding {
        private final String name;
        private final DatagramSocket socket;
        private final ManagedBindingRegistry registry;

        public WrappedManagedDatagramSocket(DatagramSocket socket, ManagedBindingRegistry registry) {
            this(null, socket, registry);
        }

        public WrappedManagedDatagramSocket(String name, DatagramSocket socket, ManagedBindingRegistry registry) {
            assert (socket != null);
            this.name = name;
            this.socket = socket;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        @Override
        public void close() throws IOException {
            try {
                this.registry.unregisterBinding(this);
            }
            finally {
                this.socket.close();
            }
        }

        @Override
        Object getWrappedObject() {
            return this.socket;
        }
    }

    private static class NetworkChannelManagedBinding
    extends WrapperBinding {
        private final String name;
        private final NetworkChannel channel;
        private final ManagedBindingRegistry registry;

        NetworkChannelManagedBinding(NetworkChannel channel, ManagedBindingRegistry registry) {
            this(null, channel, registry);
        }

        NetworkChannelManagedBinding(String name, NetworkChannel channel, ManagedBindingRegistry registry) {
            assert (channel != null);
            this.name = name;
            this.channel = channel;
            this.registry = registry;
        }

        @Override
        public String getSocketBindingName() {
            return this.name;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            try {
                return (InetSocketAddress)this.channel.getLocalAddress();
            }
            catch (ClosedChannelException e) {
                this.registry.unregisterBinding(this);
                return null;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.registry.unregisterBinding(this);
            }
            finally {
                this.channel.close();
            }
        }

        @Override
        Object getWrappedObject() {
            return this.channel;
        }
    }

    private static abstract class WrapperBinding
    implements ManagedBinding {
        private WrapperBinding() {
        }

        abstract Object getWrappedObject();

        public final int hashCode() {
            String name = this.getSocketBindingName();
            return name != null ? name.hashCode() : System.identityHashCode(this.getWrappedObject());
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrapperBinding that = (WrapperBinding)o;
            String name = this.getSocketBindingName();
            if (name != null) {
                return name.equals(that.getSocketBindingName());
            }
            return this.getWrappedObject() == that.getWrappedObject();
        }
    }
}

