/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.api.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.security.manager.WildFlySecurityManager;

final class DefaultDeploymentOperations
implements DeploymentOperations {
    private final LocalModelControllerClient controllerClient;

    DefaultDeploymentOperations(ModelControllerClientFactory clientFactory, Executor executor) {
        this.controllerClient = clientFactory.createSuperUserClient(executor, false);
    }

    @Override
    public Future<ModelNode> deploy(ModelNode operation, ExecutorService executorService) {
        return DefaultDeploymentOperations.privilegedExecution().execute(arg_0 -> ((LocalModelControllerClient)this.controllerClient).executeAsync(arg_0), operation);
    }

    @Override
    public Map<String, Boolean> getDeploymentsStatus() {
        ModelNode op = Util.getEmptyOperation((String)"read-children-resources", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        ModelNode response = DefaultDeploymentOperations.privilegedExecution().execute(arg_0 -> ((LocalModelControllerClient)this.controllerClient).execute(arg_0), op);
        if (response.get("outcome").isDefined() && !"success".equals(response.get("outcome").asString())) {
            throw DeploymentScannerLogger.ROOT_LOGGER.deployModelOperationFailed(response.get("failure-description").asString());
        }
        ModelNode result = response.get("result");
        HashMap<String, Boolean> deployments = new HashMap<String, Boolean>();
        if (result.isDefined()) {
            for (Property property : result.asPropertyList()) {
                deployments.put(property.getName(), property.getValue().get("enabled").asBoolean(false));
            }
        }
        return deployments;
    }

    @Override
    public void close() throws IOException {
        this.controllerClient.close();
    }

    @Override
    public Set<String> getUnrelatedDeployments(ModelNode owner) {
        ModelNode op = Util.getEmptyOperation((String)"read-children-resources", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        ModelNode response = DefaultDeploymentOperations.privilegedExecution().execute(arg_0 -> ((LocalModelControllerClient)this.controllerClient).execute(arg_0), op);
        if (response.get("outcome").isDefined() && !"success".equals(response.get("outcome").asString())) {
            throw DeploymentScannerLogger.ROOT_LOGGER.deployModelOperationFailed(response.get("failure-description").asString());
        }
        ModelNode result = response.get("result");
        HashSet<String> deployments = new HashSet<String>();
        if (result.isDefined()) {
            for (Property property : result.asPropertyList()) {
                if (owner.equals(property.getValue().get("owner"))) continue;
                deployments.add(property.getName());
            }
        }
        return deployments;
    }

    private static Execution privilegedExecution() {
        return WildFlySecurityManager.isChecking() ? Execution.PRIVILEGED : Execution.NON_PRIVILEGED;
    }

    private static interface Execution {
        public static final Execution NON_PRIVILEGED = new Execution(){

            @Override
            public <T, R> R execute(Function<T, R> function, T t) {
                return function.apply(t);
            }
        };
        public static final Execution PRIVILEGED = new Execution(){

            @Override
            public <T, R> R execute(Function<T, R> function, T t) {
                try {
                    return (R)AccessController.doPrivileged(() -> NON_PRIVILEGED.execute(function, t));
                }
                catch (PrivilegedActionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
        };

        public <T, R> R execute(Function<T, R> var1, T var2);
    }
}

