/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.jgroups.RequestTracker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleTargetRequest<T>
extends AbstractRequest<T> {
    private static final Log log = LogFactory.getLog(SingleTargetRequest.class);
    private final AtomicReference<RequestTracker> requestTracker;

    public SingleTargetRequest(ResponseCollector<T> wrapper, long requestId, RequestRepository repository, RequestTracker requestTracker) {
        super(requestId, wrapper, repository);
        this.requestTracker = new AtomicReference<RequestTracker>(Objects.requireNonNull(requestTracker));
    }

    @Override
    public void onResponse(Address sender, Response response) {
        RequestTracker tracker = this.requestTracker.getAndSet(null);
        try {
            if (tracker != null) {
                if (!tracker.destination().equals(sender)) {
                    log.tracef("Received unexpected response to request %d from %s, target is %s", this.requestId, sender, tracker.destination());
                }
                T result = this.addResponse(sender, tracker, response);
                this.complete(result);
            }
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    @Override
    public boolean onNewView(Set<Address> members) {
        RequestTracker tracker = this.requestTracker.get();
        try {
            if (tracker == null || members.contains(tracker.destination()) || this.requestTracker.getAndSet(null) != tracker) {
                return false;
            }
            T result = this.addResponse(tracker.destination(), tracker, CacheNotFoundResponse.INSTANCE);
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        return true;
    }

    private T addResponse(Address sender, RequestTracker tracker, Response response) {
        tracker.onComplete();
        Object result = this.responseCollector.addResponse(sender, response);
        if (result == null) {
            result = this.responseCollector.finish();
        }
        return result;
    }

    @Override
    protected void onTimeout() {
        RequestTracker tracker = this.requestTracker.getAndSet(null);
        if (tracker != null) {
            tracker.onTimeout();
            String targetString = tracker.destination().toString();
            this.completeExceptionally(Log.CLUSTER.requestTimedOut(this.requestId, targetString, Util.prettyPrintTime((long)this.getTimeoutMs())));
        }
    }
}

