/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

public class SIZE
extends Protocol {
    protected final Map<Long, LongAdder> up_map = new ConcurrentHashMap<Long, LongAdder>();
    protected final Map<Long, LongAdder> down_map = new ConcurrentHashMap<Long, LongAdder>();

    @ManagedAttribute(description="Number of down samples", type=AttributeType.SCALAR)
    public long numDownSamples() {
        return SIZE.count(this.down_map);
    }

    @ManagedAttribute(description="Number of up samples", type=AttributeType.SCALAR)
    public long numUpSamples() {
        return SIZE.count(this.up_map);
    }

    public Map<Long, LongAdder> upMap() {
        return this.up_map;
    }

    public Map<Long, LongAdder> downMap() {
        return this.down_map;
    }

    @Override
    public Object down(Message msg) {
        int len = msg.length();
        SIZE.addSample(len, this.down_map);
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        int len = msg.length();
        SIZE.addSample(len, this.up_map);
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            int len = msg.length();
            SIZE.addSample(len, this.up_map);
        }
        this.up_prot.up(batch);
    }

    @ManagedOperation(description="Clears all samples")
    public void clear() {
        this.down_map.clear();
        this.up_map.clear();
    }

    @ManagedOperation(description="Dumps the down samples")
    public String dumpDownSamples() {
        return "\n" + SIZE._dump(this.down_map);
    }

    @ManagedOperation(description="Dumps the up samples")
    public String dumpUpSamples() {
        return "\n" + SIZE._dump(this.up_map);
    }

    @ManagedOperation(description="Dumps all (down and up) samples")
    public String dump() {
        return String.format("down:\n%s\n\nup:\n%s\n", SIZE._dump(this.down_map), SIZE._dump(this.up_map));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.up_map.values().forEach(LongAdder::reset);
        this.down_map.values().forEach(LongAdder::reset);
    }

    protected static void addSample(long size, Map<Long, LongAdder> map) {
        LongAdder la = map.get(size);
        if (la == null) {
            la = map.computeIfAbsent(size, __ -> new LongAdder());
        }
        la.increment();
    }

    protected static long count(Map<Long, LongAdder> m) {
        long c = 0L;
        for (LongAdder la : m.values()) {
            c += la.sum();
        }
        return c;
    }

    protected static String _dump(Map<Long, LongAdder> m) {
        ConcurrentSkipListMap<Long, LongAdder> sm = new ConcurrentSkipListMap<Long, LongAdder>(m);
        return sm.entrySet().stream().map(e -> String.format("%,d: %,d", e.getKey(), ((LongAdder)e.getValue()).sum())).collect(Collectors.joining("\n"));
    }
}

