/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.service.deployment;

import jakarta.servlet.ServletContext;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.service.descriptor.ServiceDescriptor;

public interface WebDeploymentServiceDescriptor<T>
extends ServiceDescriptor<T> {
    public static final WebDeploymentServiceDescriptor<UnaryOperator<String>> ROUTE_LOCATOR = WebDeploymentServiceDescriptor.of("route-locator", UnaryOperator.class);
    public static final WebDeploymentServiceDescriptor<SessionManagerFactory<ServletContext, Map<String, Object>>> SESSION_MANAGER_FACTORY = WebDeploymentServiceDescriptor.of("session-manager-factory", SessionManagerFactory.class);

    default public ServiceName resolve(DeploymentUnit unit) {
        return unit.getServiceName().append(new String[]{"distributable", this.getName()});
    }

    default public <U extends T> WebDeploymentServiceDescriptor<U> asType(final Class<U> type) {
        return new WebDeploymentServiceDescriptor<U>(){

            public String getName() {
                return WebDeploymentServiceDescriptor.this.getName();
            }

            public Class<U> getType() {
                return type;
            }

            @Override
            public ServiceName resolve(DeploymentUnit unit) {
                return WebDeploymentServiceDescriptor.this.resolve(unit);
            }
        };
    }

    public static <T> WebDeploymentServiceDescriptor<T> of(final String name, final Class<T> type) {
        return new WebDeploymentServiceDescriptor<T>(){

            public String getName() {
                return name;
            }

            public Class<T> getType() {
                return type;
            }
        };
    }
}

