/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public abstract class AbstractSession
implements Session,
Supplier<org.wildfly.clustering.session.Session<Map<String, Object>>> {
    private static final Set<String> AUTO_REAUTHENTICATING_MECHANISMS = Set.of("BASIC", "DIGEST", "CLIENT_CERT");
    static final String WEB_SOCKET_CHANNELS_ATTRIBUTE = "io.undertow.websocket.current-connections";
    private static final Set<String> LOCAL_CONTEXT_ATTRIBUTES = Set.of("io.undertow.websocket.current-connections");
    private final UndertowSessionManager manager;
    private final Supplier<org.wildfly.clustering.session.Session<Map<String, Object>>> reference;

    public AbstractSession(UndertowSessionManager manager, Supplier<org.wildfly.clustering.session.Session<Map<String, Object>>> reference) {
        this.manager = manager;
        this.reference = reference;
    }

    @Override
    public org.wildfly.clustering.session.Session<Map<String, Object>> get() {
        return this.reference.get();
    }

    public UndertowSessionManager getSessionManager() {
        return this.manager;
    }

    public String getId() {
        return this.reference.get().getId();
    }

    public long getCreationTime() {
        return this.reference.get().getMetaData().getCreationTime().toEpochMilli();
    }

    public long getLastAccessedTime() {
        SessionMetaData metaData = this.reference.get().getMetaData();
        return Optional.ofNullable(metaData.getLastAccessStartTime()).orElseGet(() -> ((SessionMetaData)metaData).getCreationTime()).toEpochMilli();
    }

    public int getMaxInactiveInterval() {
        return (int)this.reference.get().getMetaData().getTimeout().getSeconds();
    }

    public void setMaxInactiveInterval(int interval) {
        this.reference.get().getMetaData().setTimeout(Duration.ofSeconds(interval));
    }

    public Set<String> getAttributeNames() {
        return this.reference.get().getAttributes().keySet();
    }

    public Object getAttribute(String name) {
        org.wildfly.clustering.session.Session<Map<String, Object>> session = this.reference.get();
        if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
            AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().get(name);
            return auth != null ? auth : ((Map)session.getContext()).get(name);
        }
        if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
            return ((Map)session.getContext()).get(name);
        }
        return session.getAttributes().get(name);
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        org.wildfly.clustering.session.Session<Map<String, Object>> session = this.reference.get();
        if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
            AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)value;
            return AUTO_REAUTHENTICATING_MECHANISMS.contains(auth.getMechanism()) ? ((Map)session.getContext()).put(name, auth) : session.getAttributes().put(name, auth);
        }
        if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
            return ((Map)session.getContext()).put(name, value);
        }
        Object old = session.getAttributes().put(name, value);
        if (old == null) {
            this.manager.getSessionListeners().attributeAdded((Session)this, name, value);
        } else if (old != value) {
            this.manager.getSessionListeners().attributeUpdated((Session)this, name, value, old);
        }
        return old;
    }

    public Object removeAttribute(String name) {
        org.wildfly.clustering.session.Session<Map<String, Object>> session = this.reference.get();
        if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
            AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().remove(name);
            return auth != null ? auth : ((Map)session.getContext()).remove(name);
        }
        if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
            return ((Map)session.getContext()).remove(name);
        }
        Object old = session.getAttributes().remove(name);
        if (old != null) {
            this.manager.getSessionListeners().attributeRemoved((Session)this, name, old);
        }
        return old;
    }

    public void invalidate(HttpServerExchange exchange) {
        this.reference.get().invalidate();
    }
}

