/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.TypeDescriptor;

public final class IckleParsingResult<TypeMetadata> {
    private final String queryString;
    private final StatementType statementType;
    private final Set<String> parameterNames;
    private final BooleanExpr whereClause;
    private final BooleanExpr havingClause;
    private final BooleanExpr filteringClause;
    private final String targetEntityName;
    private final TypeMetadata targetEntityMetadata;
    private final PropertyPath<?>[] projectedPaths;
    private final Class<?>[] projectedTypes;
    private final Object[] projectedNullMarkers;
    private final PropertyPath<?>[] groupBy;
    private final SortField[] sortFields;

    public IckleParsingResult(String queryString, StatementType statementType, Set<String> parameterNames, BooleanExpr whereClause, BooleanExpr havingClause, BooleanExpr filteringClause, String targetEntityName, TypeMetadata targetEntityMetadata, PropertyPath<?>[] projectedPaths, Class<?>[] projectedTypes, Object[] projectedNullMarkers, PropertyPath<?>[] groupBy, SortField[] sortFields) {
        this.queryString = queryString;
        this.statementType = statementType;
        this.parameterNames = parameterNames;
        this.whereClause = whereClause;
        this.havingClause = havingClause;
        this.filteringClause = filteringClause;
        this.targetEntityName = targetEntityName;
        this.targetEntityMetadata = targetEntityMetadata;
        if (projectedPaths != null && (projectedTypes == null || projectedTypes.length != projectedPaths.length) || projectedPaths == null && projectedTypes != null) {
            throw new IllegalArgumentException("projectedPaths and projectedTypes sizes must match");
        }
        this.projectedPaths = projectedPaths;
        this.projectedTypes = projectedTypes;
        this.projectedNullMarkers = projectedNullMarkers;
        this.groupBy = groupBy;
        this.sortFields = sortFields;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public Set<String> getParameterNames() {
        return this.parameterNames;
    }

    public BooleanExpr getWhereClause() {
        return this.whereClause;
    }

    public BooleanExpr getHavingClause() {
        return this.havingClause;
    }

    public BooleanExpr getFilteringClause() {
        return this.filteringClause;
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public TypeMetadata getTargetEntityMetadata() {
        return this.targetEntityMetadata;
    }

    public boolean hasScoreProjection() {
        if (this.projectedPaths == null) {
            return false;
        }
        return ((Stream)Arrays.stream(this.projectedPaths).sequential()).anyMatch(propertyPath -> "__ISPN_Score".equals(propertyPath.asStringPath()));
    }

    public String[] getProjections() {
        if (this.projectedPaths == null) {
            return null;
        }
        String[] projections = new String[this.projectedPaths.length];
        for (int i = 0; i < this.projectedPaths.length; ++i) {
            projections[i] = this.projectedPaths[i].toString();
        }
        return projections;
    }

    public PropertyPath<?>[] getProjectedPaths() {
        return this.projectedPaths;
    }

    public Class<?>[] getProjectedTypes() {
        return this.projectedTypes;
    }

    public Object[] getProjectedNullMarkers() {
        return this.projectedNullMarkers;
    }

    public boolean hasGroupingOrAggregations() {
        if (this.groupBy != null || this.havingClause != null) {
            return true;
        }
        if (this.projectedPaths != null) {
            for (PropertyPath<?> p : this.projectedPaths) {
                if (!(p instanceof AggregationPropertyPath)) continue;
                return true;
            }
        }
        if (this.sortFields != null) {
            for (SortField s : this.sortFields) {
                if (!(s.getPath() instanceof AggregationPropertyPath)) continue;
                return true;
            }
        }
        return false;
    }

    public PropertyPath<?>[] getGroupBy() {
        return this.groupBy;
    }

    public SortField[] getSortFields() {
        return this.sortFields;
    }

    public String toString() {
        return "IckleParsingResult [ queryString=" + this.queryString + ", statementType=" + String.valueOf((Object)this.statementType) + ", targetEntityName=" + this.targetEntityName + ", parameterNames=" + String.valueOf(this.parameterNames) + ", whereClause=" + String.valueOf(this.whereClause) + ", havingClause=" + String.valueOf(this.havingClause) + ", projectedPaths=" + Arrays.toString(this.projectedPaths) + ", projectedTypes=" + Arrays.toString(this.projectedTypes) + ", projectedNullMarkers=" + Arrays.toString(this.projectedNullMarkers) + ", groupBy=" + Arrays.toString(this.groupBy) + ", sortFields=" + Arrays.toString(this.sortFields) + "]";
    }

    public static enum StatementType {
        SELECT,
        DELETE;

        private static final StatementType[] CACHED_VALUES;

        public static StatementType valueOf(int index) {
            return CACHED_VALUES[index];
        }

        static {
            CACHED_VALUES = StatementType.values();
        }
    }

    static final class SortFieldImpl<TypeMetadata>
    implements SortField {
        public final PropertyPath<TypeDescriptor<TypeMetadata>> path;
        public final boolean isAscending;

        SortFieldImpl(PropertyPath<TypeDescriptor<TypeMetadata>> path, boolean isAscending) {
            this.path = path;
            this.isAscending = isAscending;
        }

        public PropertyPath<TypeDescriptor<TypeMetadata>> getPath() {
            return this.path;
        }

        @Override
        public boolean isAscending() {
            return this.isAscending;
        }

        public String toString() {
            return "SortField(" + String.valueOf(this.path) + ", " + (this.isAscending ? "ASC" : "DESC") + ")";
        }
    }
}

