/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.webservices.deployers.AspectDeploymentProcessor;
import org.jboss.as.webservices.deployers.GracefulShutdownIntegrationProcessor;
import org.jboss.as.webservices.deployers.JBossWebservicesDescriptorDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSClassVerificationProcessor;
import org.jboss.as.webservices.deployers.WSDependenciesProcessor;
import org.jboss.as.webservices.deployers.WSIntegrationProcessorJAXWS_EJB;
import org.jboss.as.webservices.deployers.WSIntegrationProcessorJAXWS_HANDLER;
import org.jboss.as.webservices.deployers.WSIntegrationProcessorJAXWS_JMS;
import org.jboss.as.webservices.deployers.WSIntegrationProcessorJAXWS_POJO;
import org.jboss.as.webservices.deployers.WSLibraryFilterProcessor;
import org.jboss.as.webservices.deployers.WSModelDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSServiceDependenciesProcessor;
import org.jboss.as.webservices.deployers.WebServiceAnnotationProcessor;
import org.jboss.as.webservices.deployers.WebServicesContextJndiSetupProcessor;
import org.jboss.as.webservices.deployers.WebservicesDescriptorDeploymentProcessor;
import org.jboss.as.webservices.deployers.deployment.DeploymentAspectsProvider;
import org.jboss.as.webservices.injection.WSHandlerChainAnnotationProcessor;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.ModuleClassLoaderProvider;
import org.jboss.as.webservices.webserviceref.WSRefAnnotationProcessor;
import org.jboss.as.webservices.webserviceref.WSRefDDProcessor;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

final class WSDeploymentActivator {
    WSDeploymentActivator() {
    }

    static void activate(DeploymentProcessorTarget processorTarget, boolean appclient) {
        if (!WSDeploymentActivator.isModularEnvironment()) {
            return;
        }
        processorTarget.addDeploymentProcessor("webservices", Phase.POST_MODULE, 6144, (DeploymentUnitProcessor)new WSRefDDProcessor());
        processorTarget.addDeploymentProcessor("webservices", Phase.POST_MODULE, 6145, (DeploymentUnitProcessor)new WSRefAnnotationProcessor());
        processorTarget.addDeploymentProcessor("webservices", Phase.DEPENDENCIES, 3072, (DeploymentUnitProcessor)new WSDependenciesProcessor(!appclient));
        if (!appclient) {
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8256, (DeploymentUnitProcessor)new WebServicesContextJndiSetupProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8261, (DeploymentUnitProcessor)new WSLibraryFilterProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8265, (DeploymentUnitProcessor)new WebservicesDescriptorDeploymentProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8272, (DeploymentUnitProcessor)new JBossWebservicesDescriptorDeploymentProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8273, (DeploymentUnitProcessor)new WebServiceAnnotationProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8274, (DeploymentUnitProcessor)new WSIntegrationProcessorJAXWS_EJB());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8277, (DeploymentUnitProcessor)new WSHandlerChainAnnotationProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8278, (DeploymentUnitProcessor)new WSIntegrationProcessorJAXWS_JMS());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8280, (DeploymentUnitProcessor)new WSIntegrationProcessorJAXWS_POJO());
            processorTarget.addDeploymentProcessor("webservices", Phase.PARSE, 8288, (DeploymentUnitProcessor)new WSIntegrationProcessorJAXWS_HANDLER());
            processorTarget.addDeploymentProcessor("webservices", Phase.STRUCTURE, 8448, (DeploymentUnitProcessor)new WSServiceDependenciesProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.POST_MODULE, 6272, (DeploymentUnitProcessor)new GracefulShutdownIntegrationProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.INSTALL, 7177, (DeploymentUnitProcessor)new WSClassVerificationProcessor());
            processorTarget.addDeploymentProcessor("webservices", Phase.INSTALL, 7184, (DeploymentUnitProcessor)new WSModelDeploymentProcessor());
            WSDeploymentActivator.addDeploymentProcessors(processorTarget, Phase.INSTALL, 7185);
        }
    }

    private static void addDeploymentProcessors(DeploymentProcessorTarget processorTarget, Phase phase, int priority) {
        int index = 1;
        List<DeploymentAspect> aspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
        for (DeploymentAspect da : aspects) {
            if (WSLogger.ROOT_LOGGER.isTraceEnabled()) {
                WSLogger.ROOT_LOGGER.tracef("Installing aspect %s", da.getClass().getName());
            }
            processorTarget.addDeploymentProcessor("webservices", phase, priority + index++, (DeploymentUnitProcessor)new AspectDeploymentProcessor(da));
        }
    }

    private static boolean isModularEnvironment() {
        try {
            ModuleClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
            return true;
        }
        catch (Exception e) {
            WSLogger.ROOT_LOGGER.couldNotActivateSubsystem(e);
            return false;
        }
    }
}

