/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.distributable;

import jakarta.ejb.ConcurrentAccessTimeoutException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCacheConfiguration;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.Affinity;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.ejb.bean.Bean;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanManager;
import org.wildfly.clustering.function.Consumer;

public class DistributableStatefulSessionBeanCache<K, V extends StatefulSessionBeanInstance<K>>
implements StatefulSessionBeanCache<K, V> {
    private static final Object UNSET = Boolean.TRUE;
    private final BeanManager<K, V> manager;
    private final StatefulSessionBeanInstanceFactory<V> factory;

    public DistributableStatefulSessionBeanCache(DistributableStatefulSessionBeanCacheConfiguration<K, V> configuration) {
        this.manager = configuration.getBeanManager();
        this.factory = configuration.getInstanceFactory();
    }

    public boolean isStarted() {
        return this.manager.isStarted();
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public Affinity getStrongAffinity() {
        return this.manager.getStrongAffinity();
    }

    public Affinity getWeakAffinity(K id) {
        return this.manager.getWeakAffinity(id);
    }

    @Override
    public StatefulSessionBean<K, V> createStatefulSessionBean() {
        boolean newGroup;
        boolean bl = newGroup = CURRENT_GROUP.get() == null;
        if (newGroup) {
            CURRENT_GROUP.set(UNSET);
        }
        try {
            DistributableStatefulSessionBean distributableStatefulSessionBean;
            block21: {
                Map.Entry<V, SuspendedBatch> entry = this.createInstance();
                StatefulSessionBeanInstance instance = (StatefulSessionBeanInstance)entry.getKey();
                SuspendedBatch batch = entry.getValue();
                Object id = instance.getId();
                if (CURRENT_GROUP.get() == UNSET) {
                    CURRENT_GROUP.set(id);
                }
                Context context = batch.resumeWithContext();
                try {
                    Bean bean = this.manager.createBean((BeanInstance)instance, CURRENT_GROUP.get());
                    distributableStatefulSessionBean = new DistributableStatefulSessionBean(bean, batch);
                    if (context == null) break block21;
                }
                catch (Throwable bean) {
                    try {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable) {
                                bean.addSuppressed(throwable);
                            }
                        }
                        throw bean;
                    }
                    catch (Error | RuntimeException e) {
                        try (Context context2 = batch.resumeWithContext();){
                            DistributableStatefulSessionBeanCache.rollback((Supplier<Batch>)context2);
                        }
                        throw e;
                    }
                }
                context.close();
            }
            return distributableStatefulSessionBean;
        }
        finally {
            if (newGroup) {
                CURRENT_GROUP.remove();
            }
        }
    }

    private Map.Entry<V, SuspendedBatch> createInstance() {
        SuspendedBatch batch = ((Batch)this.manager.getBatchFactory().get()).suspend();
        try (Context context = batch.resumeWithContext();){
            Map.Entry<StatefulSessionBeanInstance, SuspendedBatch> entry = Map.entry((StatefulSessionBeanInstance)this.factory.createInstance(), batch);
            return entry;
        }
    }

    @Override
    public StatefulSessionBean<K, V> findStatefulSessionBean(K id) {
        StatefulSessionBean statefulSessionBean;
        block15: {
            SuspendedBatch suspended = ((Batch)this.manager.getBatchFactory().get()).suspend();
            Context context = suspended.resumeWithContext();
            try {
                Bean bean = this.manager.findBean(id);
                StatefulSessionBean statefulSessionBean2 = statefulSessionBean = bean != null ? new DistributableStatefulSessionBean(bean, suspended) : this.close((Supplier<Batch>)context);
                if (context == null) break block15;
            }
            catch (Throwable bean) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            bean.addSuppressed(throwable);
                        }
                    }
                    throw bean;
                }
                catch (TimeoutException e) {
                    throw new ConcurrentAccessTimeoutException(e.getMessage());
                }
                catch (Error | RuntimeException e) {
                    try (Context batch = suspended.resumeWithContext();){
                        DistributableStatefulSessionBeanCache.rollback((Supplier<Batch>)batch);
                    }
                    throw e;
                }
            }
            context.close();
        }
        return statefulSessionBean;
    }

    private StatefulSessionBean<K, V> close(Supplier<Batch> batch) {
        DistributableStatefulSessionBeanCache.close(batch, (Consumer<Batch>)Consumer.empty());
        return null;
    }

    private static void rollback(Supplier<Batch> batch) {
        DistributableStatefulSessionBeanCache.close(batch, (Consumer<Batch>)((Consumer)Batch::discard));
    }

    private static void close(Supplier<Batch> batchProvider, Consumer<Batch> action) {
        try (Batch batch = batchProvider.get();){
            action.accept((Object)batch);
        }
        catch (Error | RuntimeException e) {
            EjbLogger.EJB3_INVOCATION_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    public int getActiveCount() {
        return this.manager.getActiveCount();
    }

    public int getPassiveCount() {
        return this.manager.getPassiveCount();
    }

    @Override
    public Supplier<K> getIdentifierFactory() {
        return this.manager.getIdentifierFactory();
    }

    @Override
    public boolean isRemotable(Throwable throwable) {
        return this.manager.isRemotable(throwable);
    }
}

