/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;

public class IdentityResourceDefinition
extends SimpleResourceDefinition {
    private static final String SECURITY_DOMAIN_CAPABILITY_NAME = "org.wildfly.security.security-domain";
    public static final String IDENTITY_CAPABILITY_NAME = "org.wildfly.ejb3.identity";
    static final RuntimeCapability<Void> IDENTITY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.ejb3.identity", Function.class).build();
    public static final StringListAttributeDefinition OUTFLOW_SECURITY_DOMAINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("outflow-security-domains").setRequired(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAttributeParser(AttributeParser.STRING_LIST)).setCapabilityReference("org.wildfly.security.security-domain", IDENTITY_CAPABILITY)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{OUTFLOW_SECURITY_DOMAINS};

    IdentityResourceDefinition(List<String> outflowSecurityDomains) {
        super(new SimpleResourceDefinition.Parameters(EJB3SubsystemModel.IDENTITY_PATH, EJB3Extension.getResourceDescriptionResolver("identity")).setAddHandler((OperationStepHandler)new AddHandler(outflowSecurityDomains)).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setCapabilities(new RuntimeCapability[]{IDENTITY_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)handler);
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private final List<String> outflowSecurityDomains;

        private AddHandler(List<String> outflowSecurityDomains) {
            super(new AttributeDefinition[]{OUTFLOW_SECURITY_DOMAINS});
            this.outflowSecurityDomains = outflowSecurityDomains;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            this.outflowSecurityDomains.clear();
            this.outflowSecurityDomains.addAll(OUTFLOW_SECURITY_DOMAINS.unwrap((ExpressionResolver)context, resource.getModel()));
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ArrayList<Supplier<SecurityDomain>> outflowSecurityDomainSuppliers = new ArrayList<Supplier<SecurityDomain>>();
            CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(IDENTITY_CAPABILITY);
            Consumer consumer = sb.provides(IDENTITY_CAPABILITY);
            for (String outflowSecurityDomain : this.outflowSecurityDomains) {
                outflowSecurityDomainSuppliers.add(sb.requiresCapability(IdentityResourceDefinition.SECURITY_DOMAIN_CAPABILITY_NAME, SecurityDomain.class, new String[]{outflowSecurityDomain}));
            }
            IdentityService identityService = new IdentityService(consumer, outflowSecurityDomainSuppliers);
            sb.setInstance((Service)identityService).install();
        }
    }

    static class IdentityService
    implements Service {
        private final Consumer<Function<SecurityIdentity, Set<SecurityIdentity>>> consumer;
        private final List<Supplier<SecurityDomain>> outflowSecurityDomainSuppliers;
        private Set<SecurityDomain> outflowSecurityDomains = new HashSet<SecurityDomain>();

        private IdentityService(Consumer<Function<SecurityIdentity, Set<SecurityIdentity>>> consumer, List<Supplier<SecurityDomain>> outflowSecurityDomainSuppliers) {
            this.consumer = consumer;
            this.outflowSecurityDomainSuppliers = outflowSecurityDomainSuppliers;
        }

        public void start(StartContext context) throws StartException {
            HashSet<SecurityDomain> securityDomains = new HashSet<SecurityDomain>();
            for (Supplier<SecurityDomain> outflowSecurityDomainInjector : this.outflowSecurityDomainSuppliers) {
                SecurityDomain value = outflowSecurityDomainInjector.get();
                securityDomains.add(value);
            }
            this.outflowSecurityDomains.addAll(securityDomains);
            this.consumer.accept(this::outflowIdentity);
        }

        private Set<SecurityIdentity> outflowIdentity(SecurityIdentity securityIdentity) {
            HashSet<SecurityIdentity> outflowedIdentities = new HashSet<SecurityIdentity>(this.outflowSecurityDomains.size());
            if (securityIdentity != null) {
                for (SecurityDomain outflowSecurityDomain : this.outflowSecurityDomains) {
                    try {
                        ServerAuthenticationContext serverAuthenticationContext = outflowSecurityDomain.createNewAuthenticationContext();
                        if (!serverAuthenticationContext.importIdentity(securityIdentity)) continue;
                        outflowedIdentities.add(serverAuthenticationContext.getAuthorizedIdentity());
                    }
                    catch (IllegalStateException | RealmUnavailableException throwable) {}
                }
            }
            return outflowedIdentities;
        }

        public void stop(StopContext context) {
            this.consumer.accept(null);
            this.outflowSecurityDomains.clear();
        }
    }
}

