/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestRootContext;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class FieldProjectionRequestContext
implements ProjectionRequestContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ProjectionRequestRootContext root;
    private final String absoluteCurrentFieldPath;
    private final String[] absoluteCurrentFieldPathComponents;
    private final String[] relativeCurrentFieldPathComponents;

    public FieldProjectionRequestContext(ProjectionRequestRootContext root, String absoluteCurrentFieldPath, String[] absoluteCurrentFieldPathComponents) {
        this(root, absoluteCurrentFieldPath, absoluteCurrentFieldPathComponents, absoluteCurrentFieldPathComponents);
    }

    private FieldProjectionRequestContext(ProjectionRequestRootContext root, String absoluteCurrentFieldPath, String[] absoluteCurrentFieldPathComponents, String[] relativeCurrentFieldPathComponents) {
        this.root = root;
        this.absoluteCurrentFieldPath = absoluteCurrentFieldPath;
        this.absoluteCurrentFieldPathComponents = absoluteCurrentFieldPathComponents;
        this.relativeCurrentFieldPathComponents = relativeCurrentFieldPathComponents;
    }

    @Override
    public void checkValidField(String absoluteFieldPath) {
        if (!FieldPaths.isStrictPrefix((String)this.absoluteCurrentFieldPath, (String)absoluteFieldPath)) {
            throw log.invalidContextForProjectionOnField(absoluteFieldPath, this.absoluteCurrentFieldPath);
        }
    }

    @Override
    public void checkNotNested(SearchQueryElementTypeKey<?> projectionKey, String hint) {
        if (this.absoluteCurrentFieldPath() != null) {
            throw log.cannotUseProjectionInNestedContext(projectionKey.toString(), hint, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteCurrentFieldPath()));
        }
    }

    @Override
    public ProjectionRequestRootContext root() {
        return this.root;
    }

    @Override
    public ProjectionRequestContext forField(String absoluteFieldPath, String[] absoluteFieldPathComponents) {
        this.checkValidField(absoluteFieldPath);
        String[] relativeFieldPathComponents = Arrays.copyOfRange(absoluteFieldPathComponents, this.absoluteCurrentFieldPathComponents.length, absoluteFieldPathComponents.length);
        return new FieldProjectionRequestContext(this.root, absoluteFieldPath, absoluteFieldPathComponents, relativeFieldPathComponents);
    }

    @Override
    public String absoluteCurrentFieldPath() {
        return this.absoluteCurrentFieldPath;
    }

    @Override
    public String[] relativeCurrentFieldPathComponents() {
        return this.relativeCurrentFieldPathComponents;
    }

    @Override
    public NamedValues queryParameters() {
        return this.root().queryParameters();
    }

    @Override
    public boolean projectionCardinalityCorrectlyAddressed(String requiredContextAbsoluteFieldPath) {
        return requiredContextAbsoluteFieldPath == null || requiredContextAbsoluteFieldPath.equals(this.absoluteCurrentFieldPath) || this.absoluteCurrentFieldPath != null && this.absoluteCurrentFieldPath.startsWith(requiredContextAbsoluteFieldPath + ".");
    }
}

