/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.PrefixPredicateBuilder;

public class LuceneTextPrefixPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneTextPrefixPredicate(Builder<?> builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements PrefixPredicateBuilder {
        private final Analyzer analyzerOrNormalizer;
        private String prefix;

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.analyzerOrNormalizer = field.type().searchAnalyzerOrNormalizer();
        }

        public void prefix(String prefix) {
            this.prefix = prefix;
        }

        public SearchPredicate build() {
            return new LuceneTextPrefixPredicate(this);
        }

        @Override
        protected Query buildQuery(PredicateRequestContext context) {
            return new PrefixQuery(new Term(this.absoluteFieldPath, this.analyzerOrNormalizer.normalize(this.absoluteFieldPath, this.prefix)));
        }
    }

    public static class Factory<F>
    extends AbstractLuceneValueFieldSearchQueryElementFactory<PrefixPredicateBuilder, F> {
        @Override
        public PrefixPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder<F>(scope, field);
        }
    }
}

