/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.CommonAttributes;
import org.jboss.as.platform.mbean.ExtendedThreadMBean;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanThreadsAllocatedBytesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-threads-allocated-bytes", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setParameters(new AttributeDefinition[]{CommonAttributes.IDS}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.LONG).setRuntimeOnly().setReadOnly().setStability(Stability.COMMUNITY).build();
    public static final ThreadMXBeanThreadsAllocatedBytesHandler INSTANCE = new ThreadMXBeanThreadsAllocatedBytesHandler();
    private final ParametersValidator idsValidator = new ParametersValidator();

    private ThreadMXBeanThreadsAllocatedBytesHandler() {
        this.idsValidator.registerValidator("ids", (ParameterValidator)new ListValidator(LongRangeValidator.POSITIVE));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.idsValidator.validate(operation);
        ExtendedThreadMBean mbean = new ExtendedThreadMBean();
        if (mbean.isOperationDefined("getThreadAllocatedBytes", new String[]{long[].class.getName()})) {
            try {
                long[] ids = this.getIds(operation);
                long[] times = mbean.getThreadAllocatedBytes(ids);
                context.getResult().setEmptyList();
                long[] lArray = times;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long time = lArray[i];
                    context.getResult().add(time.longValue());
                }
            }
            catch (UnsupportedOperationException e) {
                throw new OperationFailedException(e.toString());
            }
        } else {
            throw PlatformMBeanLogger.ROOT_LOGGER.unsupportedOperation("get-thread-cpu-times");
        }
    }

    private long[] getIds(ModelNode operation) throws OperationFailedException {
        List idNodes = operation.require("ids").asList();
        long[] ids = new long[idNodes.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((ModelNode)idNodes.get(i)).asLong();
        }
        return ids;
    }
}

