/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.QuaternaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceResolver;
import org.wildfly.subsystem.resource.capability.NaryServiceDescriptor;

public interface CapabilityReference<T>
extends CapabilityReferenceRecorder,
CapabilityReferenceResolver<T> {
    public RuntimeCapability<Void> getDependent();

    default public String getBaseRequirementName() {
        return this.getRequirement().getName();
    }

    default public String getBaseDependentName() {
        return this.getDependent().getName();
    }

    public static <T> Builder<T> builder(RuntimeCapability<Void> capability, UnaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement));
    }

    public static <T> ParentPathProvider<T> builder(RuntimeCapability<Void> capability, BinaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement));
    }

    public static <T> GrandparentPathProvider<T> builder(RuntimeCapability<Void> capability, TernaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement));
    }

    public static <T> GreatGrandparentPathProvider<T> builder(RuntimeCapability<Void> capability, QuaternaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement));
    }

    public static class DefaultBuilder<T>
    implements GreatGrandparentPathProvider<T>,
    GrandparentPathProvider<T>,
    ParentPathProvider<T>,
    Builder<T> {
        static final Function<PathAddress, PathElement> CHILD_PATH = PathAddress::getLastElement;
        static final Function<PathAddress, PathElement> PARENT_PATH = CHILD_PATH.compose(PathAddress::getParent);
        static final Function<PathAddress, PathElement> GRANDPARENT_PATH = PARENT_PATH.compose(PathAddress::getParent);
        private static final RequirementNameSegmentResolver CHILD_REQUIREMENT_NAME_SEGMENT_RESOLVER = (context, resource, value) -> value;
        private static final UnaryOperator<String> CHILD_REQUIREMENT_PATTERN_SEGMENT_RESOLVER = UnaryOperator.identity();
        private final RuntimeCapability<Void> capability;
        private final NaryServiceDescriptor<T> requirement;
        private final List<RequirementNameSegmentResolver> requirementNameSegmentResolvers = new ArrayList<RequirementNameSegmentResolver>(4);
        private final List<UnaryOperator<String>> requirementPatternSegmentResolvers = new ArrayList<UnaryOperator<String>>(4);

        DefaultBuilder(RuntimeCapability<Void> capability, NaryServiceDescriptor<T> requirement) {
            this.capability = capability;
            this.requirement = requirement;
        }

        @Override
        public GrandparentAttributeProvider<T> withGreatGrandparentAttribute(AttributeDefinition attribute) {
            return this.addAttributeResolver(attribute);
        }

        @Override
        public ParentAttributeProvider<T> withGrandparentAttribute(AttributeDefinition attribute) {
            return this.addAttributeResolver(attribute);
        }

        @Override
        public Builder<T> withParentAttribute(AttributeDefinition attribute) {
            return this.addAttributeResolver(attribute);
        }

        @Override
        public GrandparentPathProvider<T> withGreatGrandparentPath(PathElement path, Function<PathAddress, PathElement> resolver) {
            return this.addPathResolver(path, resolver);
        }

        @Override
        public ParentPathProvider<T> withGrandparentPath(PathElement path, Function<PathAddress, PathElement> resolver) {
            return this.addPathResolver(path, resolver);
        }

        @Override
        public Builder<T> withParentPath(PathElement path, Function<PathAddress, PathElement> resolver) {
            return this.addPathResolver(path, resolver);
        }

        private DefaultBuilder<T> addAttributeResolver(AttributeDefinition attribute) {
            this.requirementNameSegmentResolvers.add(DefaultBuilder.createRequirementNameSegmentResolver(attribute));
            this.requirementPatternSegmentResolvers.add(DefaultBuilder.createRequirementPatternSegmentResolver(attribute));
            return this;
        }

        private DefaultBuilder<T> addPathResolver(PathElement path, Function<PathAddress, PathElement> resolver) {
            this.requirementNameSegmentResolvers.add(DefaultBuilder.createRequirementNameSegmentResolver(resolver));
            this.requirementPatternSegmentResolvers.add(DefaultBuilder.createRequirementPatternSegmentResolver(path));
            return this;
        }

        private static RequirementNameSegmentResolver createRequirementNameSegmentResolver(final AttributeDefinition attribute) {
            return new RequirementNameSegmentResolver(){

                @Override
                public String resolve(OperationContext context, Resource resource, String value) {
                    try {
                        return attribute.resolveModelAttribute(context, resource.getModel()).asStringOrNull();
                    }
                    catch (OperationFailedException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            };
        }

        private static RequirementNameSegmentResolver createRequirementNameSegmentResolver(final Function<PathAddress, PathElement> resolver) {
            return new RequirementNameSegmentResolver(){

                @Override
                public String resolve(OperationContext context, Resource resource, String value) {
                    return ((PathElement)resolver.apply(context.getCurrentAddress())).getValue();
                }
            };
        }

        private static UnaryOperator<String> createRequirementPatternSegmentResolver(final AttributeDefinition attribute) {
            return new UnaryOperator<String>(){

                @Override
                public String apply(String name) {
                    return attribute.getName();
                }
            };
        }

        private static UnaryOperator<String> createRequirementPatternSegmentResolver(final PathElement path) {
            return new UnaryOperator<String>(){

                @Override
                public String apply(String name) {
                    return path.getKey();
                }
            };
        }

        @Override
        public CapabilityReference<T> build() {
            this.requirementNameSegmentResolvers.add(CHILD_REQUIREMENT_NAME_SEGMENT_RESOLVER);
            this.requirementPatternSegmentResolvers.add(CHILD_REQUIREMENT_PATTERN_SEGMENT_RESOLVER);
            return new ServiceDescriptorReference<T>(this.capability, this.requirement, this.requirementNameSegmentResolvers, this.requirementPatternSegmentResolvers);
        }
    }

    public static interface RequirementNameSegmentResolver {
        public String resolve(OperationContext var1, Resource var2, String var3);
    }

    public static class ServiceDescriptorReference<T>
    extends AbstractServiceDescriptorReference<T> {
        private final List<RequirementNameSegmentResolver> requirementNameSegmentResolvers;
        private final List<UnaryOperator<String>> requirementPatternSegmentResolvers;

        ServiceDescriptorReference(RuntimeCapability<Void> capability, NaryServiceDescriptor<T> requirement, List<RequirementNameSegmentResolver> requirementNameSegmentResolvers, List<UnaryOperator<String>> requirementPatternSegmentResolvers) {
            super(capability, requirement);
            this.requirementNameSegmentResolvers = List.copyOf(requirementNameSegmentResolvers);
            this.requirementPatternSegmentResolvers = List.copyOf(requirementPatternSegmentResolvers);
        }

        @Override
        public Map.Entry<String, String[]> resolve(OperationContext context, Resource resource, String value) {
            String[] segments = new String[this.requirementNameSegmentResolvers.size()];
            ListIterator<RequirementNameSegmentResolver> resolvers = this.requirementNameSegmentResolvers.listIterator();
            while (resolvers.hasNext()) {
                segments[resolvers.nextIndex()] = resolvers.next().resolve(context, resource, value);
            }
            return this.getRequirement().resolve(segments);
        }

        public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
            String dependentName = this.resolveDependentName(context);
            for (String value : values) {
                if (value == null) continue;
                context.registerAdditionalCapabilityRequirement(this.resolveRequirementName(context, resource, value), dependentName, attributeName);
            }
        }

        public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
            String dependentName = this.resolveDependentName(context);
            for (String value : values) {
                if (value == null) continue;
                context.deregisterCapabilityRequirement(this.resolveRequirementName(context, resource, value), dependentName, attributeName);
            }
        }

        private String resolveRequirementName(OperationContext context, Resource resource, String value) {
            Map.Entry<String, String[]> resolved = this.resolve(context, resource, value);
            return resolved.getValue().length > 0 ? RuntimeCapability.buildDynamicCapabilityName((String)resolved.getKey(), (String[])resolved.getValue()) : resolved.getKey();
        }

        public String[] getRequirementPatternSegments(String name, PathAddress address) {
            String[] segments = new String[this.requirementPatternSegmentResolvers.size()];
            ListIterator<UnaryOperator<String>> resolvers = this.requirementPatternSegmentResolvers.listIterator();
            while (resolvers.hasNext()) {
                segments[resolvers.nextIndex()] = (String)resolvers.next().apply(name);
            }
            return segments;
        }
    }

    public static abstract class AbstractServiceDescriptorReference<T>
    implements CapabilityReference<T> {
        private final RuntimeCapability<Void> capability;
        private final NaryServiceDescriptor<T> requirement;

        AbstractServiceDescriptorReference(RuntimeCapability<Void> capability, NaryServiceDescriptor<T> requirement) {
            this.capability = capability;
            this.requirement = requirement;
        }

        @Override
        public RuntimeCapability<Void> getDependent() {
            return this.capability;
        }

        @Override
        public NaryServiceDescriptor<T> getRequirement() {
            return this.requirement;
        }

        String resolveDependentName(OperationContext context) {
            return this.capability.isDynamicallyNamed() ? this.capability.getDynamicName(context.getCurrentAddress()) : this.capability.getName();
        }

        public int hashCode() {
            return this.capability.getName().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof CapabilityReference ? this.getDependent().equals(((CapabilityReference)object).getDependent()) : false;
        }
    }

    public static interface GreatGrandparentPathProvider<T>
    extends GreatGrandparentAttributeProvider<T> {
        default public GrandparentPathProvider<T> withGreatGrandparentPath(PathElement path) {
            return this.withGreatGrandparentPath(path, DefaultBuilder.GRANDPARENT_PATH);
        }

        public GrandparentPathProvider<T> withGreatGrandparentPath(PathElement var1, Function<PathAddress, PathElement> var2);
    }

    public static interface GreatGrandparentAttributeProvider<T> {
        public GrandparentAttributeProvider<T> withGreatGrandparentAttribute(AttributeDefinition var1);
    }

    public static interface GrandparentPathProvider<T>
    extends GrandparentAttributeProvider<T> {
        default public ParentPathProvider<T> withGrandparentPath(PathElement path) {
            return this.withGrandparentPath(path, DefaultBuilder.PARENT_PATH);
        }

        public ParentPathProvider<T> withGrandparentPath(PathElement var1, Function<PathAddress, PathElement> var2);
    }

    public static interface GrandparentAttributeProvider<T> {
        public ParentAttributeProvider<T> withGrandparentAttribute(AttributeDefinition var1);
    }

    public static interface ParentPathProvider<T>
    extends ParentAttributeProvider<T> {
        default public Builder<T> withParentPath(PathElement path) {
            return this.withParentPath(path, DefaultBuilder.CHILD_PATH);
        }

        public Builder<T> withParentPath(PathElement var1, Function<PathAddress, PathElement> var2);
    }

    public static interface ParentAttributeProvider<T> {
        public Builder<T> withParentAttribute(AttributeDefinition var1);
    }

    public static interface Builder<T> {
        public CapabilityReference<T> build();
    }
}

