/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ActiveMQExceptionMessage
extends PacketImpl {
    protected ActiveMQException exception;

    public ActiveMQExceptionMessage(ActiveMQException exception) {
        super((byte)20);
        this.exception = exception;
    }

    public ActiveMQExceptionMessage() {
        super((byte)20);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public ActiveMQException getException() {
        return this.exception;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.exception.getType().getCode());
        buffer.writeNullableString(this.exception.getMessage());
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        int code = buffer.readInt();
        String msg = buffer.readNullableString();
        this.exception = ActiveMQExceptionType.createException(code, msg);
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + ", exception= " + String.valueOf(this.exception);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.exception);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ActiveMQExceptionMessage)) {
            return false;
        }
        ActiveMQExceptionMessage other = (ActiveMQExceptionMessage)obj;
        return Objects.equals(this.exception, other.exception);
    }
}

