/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;

public class MillisAddress
implements Address,
Constructable<MillisAddress> {
    protected long millis;

    public MillisAddress() {
    }

    public MillisAddress(long m) {
        this.millis = m;
    }

    public MillisAddress(String s) {
        this(Long.parseLong(s));
    }

    public long millis() {
        return this.millis;
    }

    @Override
    public Supplier<? extends MillisAddress> create() {
        return MillisAddress::new;
    }

    @Override
    public int compareTo(Address other) {
        MillisAddress val = (MillisAddress)other;
        if (this == val) {
            return 0;
        }
        return Long.compare(this.millis, val.millis);
    }

    @Override
    public int compareTo(MillisAddress val) {
        if (this == val) {
            return 0;
        }
        return Long.compare(this.millis, val.millis);
    }

    public int hashCode() {
        return (int)this.millis;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MillisAddress)) {
            return false;
        }
        MillisAddress m = (MillisAddress)obj;
        return this.millis == m.millis;
    }

    @Override
    public int serializedSize() {
        return 8;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeLong(this.millis);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.millis = in.readLong();
    }

    public String toString() {
        return String.valueOf(this.millis);
    }
}

