/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import java.io.IOException;
import java.security.AccessController;
import java.util.function.Supplier;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.httpclient.common.HttpClientXmlParser;
import org.wildfly.httpclient.common.WildflyHttpContext;

public final class ConfigurationHttpContextSupplier
implements Supplier<WildflyHttpContext> {
    private static final WildflyHttpContext CONFIGURED_HTTP_CONTEXT = AccessController.doPrivileged(() -> {
        try {
            return HttpClientXmlParser.parseHttpContext();
        }
        catch (IOException | ConfigXMLParseException e) {
            HttpClientMessages.MESSAGES.trace("Failed to parse EJBHttpContext XML definition", e);
            return new WildflyHttpContext.Builder().build();
        }
    });

    @Override
    public WildflyHttpContext get() {
        return CONFIGURED_HTTP_CONTEXT;
    }
}

