/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;

public class SourceAddressRoleDecoder
implements RoleDecoder {
    private String sourceAddress;
    private Pattern sourceAddressPattern;
    private Roles roles;

    public SourceAddressRoleDecoder(String sourceAddress, Roles roles) {
        Assert.checkNotNullParam("sourceAddress", sourceAddress);
        Assert.checkNotNullParam("roles", roles);
        this.sourceAddress = sourceAddress;
        this.roles = roles;
    }

    public SourceAddressRoleDecoder(Pattern sourceAddressPattern, Roles roles) {
        Assert.checkNotNullParam("sourceAddressPattern", sourceAddressPattern);
        Assert.checkNotNullParam("roles", roles);
        this.sourceAddressPattern = sourceAddressPattern;
        this.roles = roles;
    }

    @Override
    public Roles decodeRoles(AuthorizationIdentity authorizationIdentity) {
        Matcher matcher;
        String actualSourceAddress;
        Attributes runtimeAttributes = authorizationIdentity.getRuntimeAttributes();
        if (runtimeAttributes.containsKey("Source-Address") && (actualSourceAddress = runtimeAttributes.getFirst("Source-Address")) != null && (this.sourceAddress != null ? this.sourceAddress.equals(actualSourceAddress) : (matcher = this.sourceAddressPattern.matcher(actualSourceAddress)).matches())) {
            return this.roles;
        }
        return Roles.NONE;
    }
}

