/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.hibernate.cache.commons.access.BaseInvalidationInterceptor;
import org.infinispan.hibernate.cache.commons.util.BeginInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class NonTxInvalidationInterceptor
extends BaseInvalidationInterceptor {
    @Inject
    Transport transport;
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InvalidationInterceptor.class);
    private static final Log ispnLog = LogFactory.getLog(NonTxInvalidationInterceptor.class);
    private final InvocationSuccessFunction<RemoveCommand> handleWriteReturn = this::handleWriteReturn;
    private final InvocationSuccessFunction<RemoveCommand> handleEvictReturn = this::handleEvictReturn;

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        assert (command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ));
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        throw new UnsupportedOperationException("Unexpected replace");
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        boolean isEvict = !command.hasAnyFlag(FlagBitSets.FORCE_WRITE_LOCK);
        return this.invokeNextThenApply(ctx, (VisitableCommand)command, isEvict ? this.handleEvictReturn : this.handleWriteReturn);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        Object retval = this.invokeNext(ctx, (VisitableCommand)command);
        if (!this.isLocalModeForced((FlagAffectedCommand)command) && ctx.isOriginLocal()) {
            command.setTopologyId(this.rpcManager.getTopologyId());
            if (this.isSynchronous((FlagAffectedCommand)command)) {
                return NonTxInvalidationInterceptor.asyncValue((CompletionStage)this.rpcManager.invokeCommandOnAll((ReplicableCommand)command, (ResponseCollector)VoidResponseCollector.ignoreLeavers(), this.syncRpcOptions));
            }
            this.rpcManager.sendToAll((ReplicableCommand)command, DeliverOrder.NONE);
        }
        return retval;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        throw new UnsupportedOperationException("Unexpected putAll");
    }

    private <T extends WriteCommand & RemoteLockCommand> CompletableFuture<?> invalidateAcrossCluster(T command, boolean isTransactional, Object key, Object keyLockOwner) {
        this.incrementInvalidations();
        if (!this.isLocalModeForced((FlagAffectedCommand)command)) {
            InvalidateCommand invalidateCommand;
            if (isTransactional) {
                Address address = this.transport != null ? this.transport.getAddress() : LocalModeAddress.INSTANCE;
                invalidateCommand = new BeginInvalidationCommand(0L, CommandInvocationId.generateId((Address)address), new Object[]{key}, keyLockOwner);
            } else {
                invalidateCommand = this.commandsFactory.buildInvalidateCommand(0L, new Object[]{key});
            }
            invalidateCommand.setTopologyId(this.rpcManager.getTopologyId());
            if (this.isSynchronous((FlagAffectedCommand)command)) {
                return this.rpcManager.invokeCommandOnAll((ReplicableCommand)invalidateCommand, (ResponseCollector)VoidResponseCollector.ignoreLeavers(), this.syncRpcOptions).toCompletableFuture();
            }
            this.rpcManager.sendToAll((ReplicableCommand)invalidateCommand, DeliverOrder.NONE);
        }
        return null;
    }

    protected Log getLog() {
        return ispnLog;
    }

    private Object handleWriteReturn(InvocationContext ctx, RemoveCommand removeCmd, Object rv) {
        if (removeCmd.isSuccessful()) {
            return this.invalidateAcrossCluster(removeCmd, true, removeCmd.getKey(), removeCmd.getKeyLockOwner());
        }
        return null;
    }

    private Object handleEvictReturn(InvocationContext ctx, RemoveCommand removeCmd, Object rv) {
        if (removeCmd.isSuccessful()) {
            return this.invalidateAcrossCluster(removeCmd, false, removeCmd.getKey(), removeCmd.getKeyLockOwner());
        }
        return null;
    }
}

