/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.BiCacheEntryCreator;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.cache.ImmutableSessionFactory;
import org.wildfly.clustering.session.cache.SessionFactoryConfiguration;

public interface SessionFactory<DC, MV, AV, SC>
extends ImmutableSessionFactory<MV, AV>,
SessionFactoryConfiguration<DC, MV, AV, SC>,
BiCacheEntryCreator<String, MV, AV, Duration>,
CacheEntryRemover<String>,
AutoCloseable {
    default public Map.Entry<CompletionStage<MV>, CompletionStage<AV>> createEntry(String id, Duration context) {
        return Map.entry(this.getSessionMetaDataFactory().createValueAsync(id, context), this.getSessionAttributesFactory().createValueAsync(id, null));
    }

    default public CompletionStage<Void> removeAsync(String id) {
        return CompletableFuture.allOf(this.getSessionMetaDataFactory().removeAsync(id).toCompletableFuture(), this.getSessionAttributesFactory().removeAsync(id).toCompletableFuture());
    }

    default public CompletionStage<Void> purgeAsync(String id) {
        return CompletableFuture.allOf(this.getSessionMetaDataFactory().purgeAsync(id).toCompletableFuture(), this.getSessionAttributesFactory().purgeAsync(id).toCompletableFuture());
    }

    public Session<SC> createSession(String var1, Map.Entry<MV, AV> var2, DC var3);

    @Override
    default public void close() {
        this.getSessionMetaDataFactory().close();
        this.getSessionAttributesFactory().close();
    }
}

