/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.server.cache.CacheStrategy;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.expiration.ScheduleExpirationCommand;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactoryService;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntriesTask;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntrySchedulerService;
import org.wildfly.clustering.server.infinispan.scheduler.CacheKeysTask;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerCommand;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerService;
import org.wildfly.clustering.server.listener.ConsumerRegistry;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerService;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.scheduler.SchedulerService;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.CachedSessionManager;
import org.wildfly.clustering.session.cache.CompositeSessionFactory;
import org.wildfly.clustering.session.cache.DetachedSession;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.SessionFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.IdentityMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.MarshalledValueMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.coarse.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManager;
import org.wildfly.clustering.session.infinispan.embedded.SessionAttributeActivationNotifierFactory;
import org.wildfly.clustering.session.infinispan.embedded.SessionCacheEntryFilter;
import org.wildfly.clustering.session.infinispan.embedded.SessionCacheKeyFilter;
import org.wildfly.clustering.session.infinispan.embedded.SessionExpirationTask;
import org.wildfly.clustering.session.infinispan.embedded.attributes.CoarseSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.embedded.attributes.FineSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.embedded.metadata.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class InfinispanSessionManagerFactory<DC, SC>
implements SessionManagerFactory<DC, SC> {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(SessionExpirationTask.class, AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return SessionExpirationTask.class.getClassLoader();
        }
    }));
    private final SchedulerService<String, ExpirationMetaData> scheduler;
    private final SessionFactory<DC, ContextualSessionMetaDataEntry<SC>, Object, SC> factory;
    private final EmbeddedCacheConfiguration configuration;
    private final org.wildfly.clustering.function.Function<SessionManagerConfiguration<DC>, Registrar<SessionManager<SC>>> managerRegistrarFactory;
    private final AtomicInteger managers = new AtomicInteger();

    public <S, L> InfinispanSessionManagerFactory(final Configuration<S, DC, SC, L> configuration) {
        EmbeddedCacheConfiguration cacheConfiguration;
        this.configuration = cacheConfiguration = configuration.getCacheConfiguration();
        final SessionAttributeActivationNotifierFactory notifierFactory = new SessionAttributeActivationNotifierFactory(configuration.getSessionSpecificationProvider(), configuration.getSessionEventListenerSpecificationProvider());
        final InfinispanSessionMetaDataFactory metaDataFactory = new InfinispanSessionMetaDataFactory(this.configuration);
        final SessionAttributesFactory<DC, ?> attributesFactory = this.createSessionAttributesFactory(configuration, notifierFactory);
        this.factory = new CompositeSessionFactory(new SessionFactoryConfiguration<DC, ContextualSessionMetaDataEntry<SC>, Object, SC>(){
            final /* synthetic */ InfinispanSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
            }

            public CacheProperties getCacheProperties() {
                return cacheConfiguration.getCacheProperties();
            }

            public SessionMetaDataFactory<ContextualSessionMetaDataEntry<SC>> getSessionMetaDataFactory() {
                return metaDataFactory;
            }

            public SessionAttributesFactory<DC, Object> getSessionAttributesFactory() {
                return attributesFactory;
            }

            public Supplier<SC> getSessionContextFactory() {
                return configuration.getSessionManagerFactoryConfiguration().getSessionContextFactory();
            }
        });
        final ConsumerRegistry expirationListenerRegistry = ConsumerRegistry.newInstance(CopyOnWriteArrayList::new);
        final SessionExpirationTask<DC, ContextualSessionMetaDataEntry<SC>, Object, SC> expirationTask = new SessionExpirationTask<DC, ContextualSessionMetaDataEntry<SC>, Object, SC>(this.factory, (Supplier<Batch>)cacheConfiguration.getBatchFactory(), (java.util.function.Consumer<ImmutableSession>)expirationListenerRegistry);
        this.managerRegistrarFactory = new org.wildfly.clustering.function.Function<SessionManagerConfiguration<DC>, Registrar<SessionManager<SC>>>(this){
            final /* synthetic */ InfinispanSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
            }

            public Registrar<SessionManager<SC>> apply(final SessionManagerConfiguration<DC> managerConfiguration) {
                return new Registrar<SessionManager<SC>>(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Registration register(SessionManager<SC> manager) {
                        Registration contextRegistration = notifierFactory.register(Map.entry(managerConfiguration.getContext(), manager));
                        Registration expirationRegistration = expirationListenerRegistry.register((Object)managerConfiguration.getExpirationListener());
                        return Registration.composite(List.of(contextRegistration, expirationRegistration));
                    }
                };
            }
        };
        final Cache cache = cacheConfiguration.getCache();
        LocalSchedulerService localScheduler = new LocalSchedulerService((LocalSchedulerService.Configuration)new LocalSchedulerService.Configuration<String>(){
            final /* synthetic */ InfinispanSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
            }

            public String getName() {
                return cacheConfiguration.getName();
            }

            public Predicate<String> getTask() {
                return expirationTask;
            }

            public Duration getCloseTimeout() {
                return cacheConfiguration.getStopTimeout();
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }
        });
        final CacheEntrySchedulerService cacheEntryScheduler = new CacheEntrySchedulerService<String, SessionMetaDataKey, ContextualSessionMetaDataEntry<SC>, ExpirationMetaData>(this, localScheduler.compose((Function)org.wildfly.clustering.function.Function.identity(), ExpirationMetaData::getExpirationTime), (arg_0, arg_1) -> metaDataFactory.createImmutableSessionMetaData(arg_0, arg_1)){
            final /* synthetic */ InfinispanSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
                super(scheduler, mapper);
            }

            public void start() {
                super.start();
                CacheEntriesTask.schedule((Cache)cache, SessionCacheEntryFilter.META_DATA.cast(), (CacheEntryScheduler)this).accept((Object)CacheStreamFilter.local((Cache)cache));
            }
        };
        final CacheContainerCommandDispatcherFactory dispatcherFactory = configuration.getCommandDispatcherFactory();
        final Consumer scheduleTask = CacheEntriesTask.schedule((Cache)cache, SessionCacheEntryFilter.META_DATA.cast(), (CacheEntryScheduler)cacheEntryScheduler);
        final Consumer cancelTask = CacheKeysTask.cancel((Cache)cache, (Predicate)((Object)SessionCacheKeyFilter.META_DATA), (CacheEntryScheduler)cacheEntryScheduler);
        this.scheduler = !dispatcherFactory.getGroup().isSingleton() ? new PrimaryOwnerSchedulerService(new PrimaryOwnerSchedulerService.Configuration<String, ExpirationMetaData, Map.Entry<SessionMetaDataKey, ContextualSessionMetaDataEntry<SC>>, SessionMetaDataKey>(){
            final /* synthetic */ InfinispanSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
            }

            public SchedulerService<String, ExpirationMetaData> getScheduler() {
                return cacheEntryScheduler;
            }

            public EmbeddedCacheConfiguration getCacheConfiguration() {
                return cacheConfiguration;
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return dispatcherFactory;
            }

            public org.wildfly.clustering.function.Function<Map.Entry<String, ExpirationMetaData>, PrimaryOwnerCommand<String, ExpirationMetaData, Void>> getScheduleCommandFactory() {
                return ScheduleExpirationCommand::new;
            }

            public Consumer<CacheStreamFilter<Map.Entry<SessionMetaDataKey, ContextualSessionMetaDataEntry<SC>>>> getScheduleTask() {
                return scheduleTask;
            }

            public Consumer<CacheStreamFilter<SessionMetaDataKey>> getCancelTask() {
                return cancelTask;
            }
        }) : cacheEntryScheduler;
    }

    public SessionManager<SC> createSessionManager(SessionManagerConfiguration<DC> configuration) {
        EmbeddedCacheConfiguration cacheConfiguration = this.configuration;
        SessionFactory<DC, ContextualSessionMetaDataEntry<SC>, Object, SC> sessionFactory = this.factory;
        AffinityIdentifierFactoryService identifierFactory = new AffinityIdentifierFactoryService((Supplier)configuration.getIdentifierFactory(), cacheConfiguration.getCache());
        final Registrar registrar = (Registrar)this.managerRegistrarFactory.apply(configuration);
        SchedulerService<String, ExpirationMetaData> scheduler = this.scheduler;
        AtomicReference<8> reference = new AtomicReference<8>();
        BiFunction<String, Object, Session> detachedSessionFactory = (id, context) -> new DetachedSession(reference::getPlain, id, context);
        final AtomicInteger managers = this.managers;
        CachedSessionManager manager = new CachedSessionManager<SC>(this, (SessionManager)new InfinispanSessionManager(new InfinispanSessionManager.Configuration<DC, ContextualSessionMetaDataEntry<SC>, Object, SC>(){
            final /* synthetic */ IdentifierFactoryService val$identifierFactory;
            final /* synthetic */ SessionFactory val$sessionFactory;
            final /* synthetic */ BiFunction val$detachedSessionFactory;
            final /* synthetic */ SessionManagerConfiguration val$configuration;
            final /* synthetic */ EmbeddedCacheConfiguration val$cacheConfiguration;
            final /* synthetic */ SchedulerService val$scheduler;
            final /* synthetic */ InfinispanSessionManagerFactory this$0;
            {
                this.val$identifierFactory = identifierFactoryService;
                this.val$sessionFactory = sessionFactory;
                this.val$detachedSessionFactory = biFunction;
                this.val$configuration = sessionManagerConfiguration;
                this.val$cacheConfiguration = embeddedCacheConfiguration;
                this.val$scheduler = schedulerService;
                this.this$0 = this$0;
            }

            public IdentifierFactoryService<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionFactory<DC, ContextualSessionMetaDataEntry<SC>, Object, SC> getSessionFactory() {
                return this.val$sessionFactory;
            }

            public BiFunction<String, SC, Session<SC>> getDetachedSessionFactory() {
                return this.val$detachedSessionFactory;
            }

            public DC getContext() {
                return this.val$configuration.getContext();
            }

            public java.util.function.Consumer<ImmutableSession> getExpirationListener() {
                return this.val$configuration.getExpirationListener();
            }

            public Duration getTimeout() {
                return this.val$configuration.getTimeout();
            }

            @Override
            public EmbeddedCacheConfiguration getCacheConfiguration() {
                return this.val$cacheConfiguration;
            }

            @Override
            public Scheduler<String, ExpirationMetaData> getExpirationScheduler() {
                return this.val$scheduler;
            }
        }), (CacheFactory)CacheStrategy.CONCURRENT, (SchedulerService)scheduler){
            private final AtomicReference<Registration> registration;
            final /* synthetic */ SchedulerService val$scheduler;
            final /* synthetic */ InfinispanSessionManagerFactory this$0;
            {
                this.val$scheduler = schedulerService;
                this.this$0 = this$0;
                super(manager, cacheFactory);
                this.registration = new AtomicReference();
            }

            public void start() {
                this.registration.set(registrar.register((Object)this));
                super.start();
                if (managers.getAndIncrement() == 0) {
                    this.val$scheduler.start();
                }
            }

            public void stop() {
                if (managers.decrementAndGet() == 0) {
                    this.val$scheduler.stop();
                }
                super.stop();
                Consumer.close().accept((Object)this.registration.getAndSet(null));
            }
        };
        reference.setPlain(manager);
        return manager;
    }

    private <S, L> SessionAttributesFactory<DC, ?> createSessionAttributesFactory(Configuration<S, DC, SC, L> configuration, org.wildfly.clustering.function.Function<String, SessionAttributeActivationNotifier> detachedPassivationNotifierFactory) {
        boolean marshalling = configuration.getCacheConfiguration().getCacheProperties().isMarshalling();
        switch (configuration.getSessionManagerFactoryConfiguration().getAttributePersistenceStrategy()) {
            case FINE: {
                BiFunction<ImmutableSession, Object, SessionAttributeActivationNotifier> passivationNotifierFactory = (session, context) -> new ImmutableSessionAttributeActivationNotifier(configuration.getSessionSpecificationProvider(), configuration.getSessionEventListenerSpecificationProvider(), session, context);
                return marshalling ? new FineSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, detachedPassivationNotifierFactory, configuration.getCacheConfiguration()) : new FineSessionAttributesFactory(new IdentityMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, detachedPassivationNotifierFactory, configuration.getCacheConfiguration());
            }
            case COARSE: {
                BiFunction<ImmutableSession, Object, SessionActivationNotifier> passivationNotifierFactory = (session, context) -> new ImmutableSessionActivationNotifier(configuration.getSessionSpecificationProvider(), configuration.getSessionEventListenerSpecificationProvider(), session, context);
                return marshalling ? new CoarseSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, detachedPassivationNotifierFactory, configuration.getCacheConfiguration()) : new CoarseSessionAttributesFactory(new IdentityMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, detachedPassivationNotifierFactory, configuration.getCacheConfiguration());
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.scheduler.close();
        this.factory.close();
    }

    public static interface Configuration<S, DC, SC, L> {
        public SessionManagerFactoryConfiguration<SC> getSessionManagerFactoryConfiguration();

        public SessionSpecificationProvider<S, DC> getSessionSpecificationProvider();

        public SessionEventListenerSpecificationProvider<S, L> getSessionEventListenerSpecificationProvider();

        public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory();

        public EmbeddedCacheConfiguration getCacheConfiguration();
    }
}

