/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import org.hibernate.Incubating;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.log.IncubationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;

public final class ConfigurationHelper {
    private static final String PLACEHOLDER_START = "${";

    private ConfigurationHelper() {
    }

    public static String getString(String name, Map values) {
        Object value = values.get(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String getString(String name, Map values, String defaultValue) {
        return ConfigurationHelper.getString(name, values, () -> defaultValue);
    }

    public static String getString(String name, Map<?, ?> values, Supplier<String> defaultValueSupplier) {
        Object value = values.get(name);
        if (value != null) {
            return value.toString();
        }
        return defaultValueSupplier.get();
    }

    public static boolean getBoolean(String name, Map values) {
        return ConfigurationHelper.getBoolean(name, values, false);
    }

    public static boolean getBoolean(String name, Map values, boolean defaultValue) {
        Object raw = values.get(name);
        Boolean value = ConfigurationHelper.toBoolean(raw, defaultValue);
        if (value == null) {
            throw new ConfigurationException("Could not determine how to handle configuration raw [name=" + name + ", value=" + String.valueOf(raw) + "] as boolean");
        }
        return value;
    }

    public static Boolean toBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return null;
    }

    public static Boolean getBooleanWrapper(String name, Map values, Boolean defaultValue) {
        Object value = values.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new ConfigurationException("Could not determine how to handle configuration value [name=" + name + ", value=" + String.valueOf(value) + "] as boolean");
    }

    public static int getInt(String name, Map values, int defaultValue) {
        Object value = values.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new ConfigurationException("Could not determine how to handle configuration value [name=" + name + ", value=" + String.valueOf(value) + "(" + value.getClass().getName() + ")] as int");
    }

    public static Integer getInteger(String name, Map values) {
        Object value = values.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            String trimmed = value.toString().trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            return Integer.valueOf(trimmed);
        }
        throw new ConfigurationException("Could not determine how to handle configuration value [name=" + name + ", value=" + String.valueOf(value) + "(" + value.getClass().getName() + ")] as Integer");
    }

    public static long getLong(String name, Map values, int defaultValue) {
        Object value = values.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new ConfigurationException("Could not determine how to handle configuration value [name=" + name + ", value=" + String.valueOf(value) + "(" + value.getClass().getName() + ")] as long");
    }

    public static Map clone(Map<?, ?> configurationValues) {
        if (configurationValues == null) {
            return null;
        }
        if (configurationValues instanceof Properties) {
            return (Properties)((Properties)configurationValues).clone();
        }
        HashMap clone = new HashMap();
        for (Map.Entry<?, ?> entry : configurationValues.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public static Properties maskOut(Properties props, String key) {
        Properties clone = (Properties)props.clone();
        if (clone.get(key) != null) {
            clone.setProperty(key, "****");
        }
        return clone;
    }

    public static Properties maskOut(Properties props, String ... keys) {
        Properties clone = (Properties)props.clone();
        for (String key : keys) {
            if (clone.get(key) == null) continue;
            clone.setProperty(key, "****");
        }
        return clone;
    }

    public static String extractPropertyValue(String propertyName, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        return value;
    }

    public static String extractPropertyValue(String propertyName, Map properties) {
        String value = (String)properties.get(propertyName);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        return value;
    }

    public static String extractValue(String name, Map values, Supplier<String> fallbackValueFactory) {
        String value = ConfigurationHelper.extractPropertyValue(name, values);
        if (value != null) {
            return value;
        }
        return fallbackValueFactory.get();
    }

    public static Map toMap(String propertyName, String delim, Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        String value = ConfigurationHelper.extractPropertyValue(propertyName, properties);
        if (value != null) {
            StringTokenizer tokens = new StringTokenizer(value, delim);
            while (tokens.hasMoreTokens()) {
                map.put(tokens.nextToken(), tokens.hasMoreElements() ? tokens.nextToken() : "");
            }
        }
        return map;
    }

    public static Map toMap(String propertyName, String delim, Map properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        String value = ConfigurationHelper.extractPropertyValue(propertyName, properties);
        if (value != null) {
            StringTokenizer tokens = new StringTokenizer(value, delim);
            while (tokens.hasMoreTokens()) {
                map.put(tokens.nextToken(), tokens.hasMoreElements() ? tokens.nextToken() : "");
            }
        }
        return map;
    }

    public static String[] toStringArray(String propertyName, String delim, Properties properties) {
        return ConfigurationHelper.toStringArray(ConfigurationHelper.extractPropertyValue(propertyName, properties), delim);
    }

    public static String[] toStringArray(String stringForm, String delim) {
        if (stringForm != null) {
            return StringHelper.split(delim, stringForm);
        }
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public static void resolvePlaceHolders(Map<?, ?> configurationValues) {
        Iterator<Map.Entry<?, ?>> itr = configurationValues.entrySet().iterator();
        while (itr.hasNext()) {
            String resolved;
            Map.Entry<?, ?> entry = itr.next();
            Object value = entry.getValue();
            if (!(value instanceof String) || value.equals(resolved = ConfigurationHelper.resolvePlaceHolder((String)value))) continue;
            if (resolved == null) {
                itr.remove();
                continue;
            }
            entry.setValue(resolved);
        }
    }

    public static String resolvePlaceHolder(String property) {
        String rtn;
        if (property.indexOf(PLACEHOLDER_START) < 0) {
            return property;
        }
        StringBuilder buff = new StringBuilder();
        char[] chars = property.toCharArray();
        for (int pos = 0; pos < chars.length; ++pos) {
            if (chars[pos] == '$' && chars[pos + 1] == '{') {
                int x;
                Object systemPropertyName = "";
                for (x = pos + 2; x < chars.length && chars[x] != '}'; ++x) {
                    systemPropertyName = (String)systemPropertyName + chars[x];
                    if (x != chars.length - 1) continue;
                    throw new IllegalArgumentException("unmatched placeholder start [" + property + "]");
                }
                String systemProperty = ConfigurationHelper.extractFromSystem((String)systemPropertyName);
                buff.append(systemProperty == null ? "" : systemProperty);
                pos = x + 1;
                if (pos >= chars.length) break;
            }
            buff.append(chars[pos]);
        }
        return (rtn = buff.toString()).isEmpty() ? null : rtn;
    }

    private static String extractFromSystem(String systemPropertyName) {
        try {
            return System.getProperty(systemPropertyName);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Incubating
    public static synchronized int getPreferredSqlTypeCodeForBoolean(StandardServiceRegistry serviceRegistry) {
        Integer typeCode = serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.type.preferred_boolean_jdbc_type", TypeCodeConverter.INSTANCE);
        if (typeCode != null) {
            IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.type.preferred_boolean_jdbc_type");
            return typeCode;
        }
        return serviceRegistry.requireService(JdbcServices.class).getJdbcEnvironment().getDialect().getPreferredSqlTypeCodeForBoolean();
    }

    @Incubating
    public static synchronized int getPreferredSqlTypeCodeForDuration(StandardServiceRegistry serviceRegistry) {
        Integer explicitSetting = serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.type.preferred_duration_jdbc_type", TypeCodeConverter.INSTANCE);
        if (explicitSetting != null) {
            IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.type.preferred_duration_jdbc_type");
            return explicitSetting;
        }
        return 3015;
    }

    @Incubating
    public static synchronized int getPreferredSqlTypeCodeForUuid(StandardServiceRegistry serviceRegistry) {
        Integer explicitSetting = serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.type.preferred_uuid_jdbc_type", TypeCodeConverter.INSTANCE);
        if (explicitSetting != null) {
            IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.type.preferred_uuid_jdbc_type");
            return explicitSetting;
        }
        return 3000;
    }

    @Incubating
    public static synchronized int getPreferredSqlTypeCodeForInstant(StandardServiceRegistry serviceRegistry) {
        Integer explicitSetting = serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.type.preferred_instant_jdbc_type", TypeCodeConverter.INSTANCE);
        if (explicitSetting != null) {
            IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.type.preferred_instant_jdbc_type");
            return explicitSetting;
        }
        return 3003;
    }

    @Incubating
    public static synchronized int getPreferredSqlTypeCodeForArray(StandardServiceRegistry serviceRegistry) {
        Integer explicitSetting = serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.type.preferred_array_jdbc_type", TypeCodeConverter.INSTANCE);
        if (explicitSetting != null) {
            IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.type.preferred_array_jdbc_type");
            return explicitSetting;
        }
        return serviceRegistry.requireService(JdbcServices.class).getJdbcEnvironment().getDialect().getPreferredSqlTypeCodeForArray();
    }

    private static class TypeCodeConverter
    implements ConfigurationService.Converter<Integer> {
        public static final TypeCodeConverter INSTANCE = new TypeCodeConverter();

        private TypeCodeConverter() {
        }

        @Override
        public Integer convert(Object value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            String string = value.toString().toUpperCase(Locale.ROOT);
            Integer typeCode = JdbcTypeNameMapper.getTypeCode(string);
            if (typeCode != null) {
                return typeCode;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Couldn't interpret '%s' as JDBC type code or type code name", string));
            }
        }
    }
}

