/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.web.session.SharedSessionManagerConfig;
import org.jboss.metadata.parser.jbossweb.ReplicationConfigParser;
import org.jboss.metadata.parser.servlet.SessionConfigMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.undertow.session.SharedSessionConfigSchema;

public class SharedSessionConfigXMLReader
implements XMLElementReader<SharedSessionManagerConfig> {
    private final SharedSessionConfigSchema schema;
    private final PropertyReplacer replacer;

    public SharedSessionConfigXMLReader(SharedSessionConfigSchema schema, PropertyReplacer replacer) {
        this.schema = schema;
        this.replacer = replacer;
    }

    public void readElement(XMLExtendedStreamReader reader, SharedSessionManagerConfig result) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        if (!this.schema.since((VersionedFeature)SharedSessionConfigSchema.VERSION_2_0)) {
            result.setDistributable(true);
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "max-active-sessions": {
                    int value = Integer.parseInt(this.replacer.replaceProperties(reader.getElementText()));
                    if (value <= 0) continue block12;
                    result.setMaxActiveSessions(Integer.valueOf(value));
                    continue block12;
                }
                case "replication-config": {
                    if (this.schema.since((VersionedFeature)SharedSessionConfigSchema.VERSION_2_0)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    result.setReplicationConfig(ReplicationConfigParser.parse((XMLStreamReader)reader, (PropertyReplacer)this.replacer));
                    continue block12;
                }
                case "session-config": {
                    result.setSessionConfig(new SessionConfigMetaDataParser(this.schema.getServletVersion()).parse((XMLStreamReader)reader, this.replacer));
                    continue block12;
                }
                case "distributable": {
                    if (!this.schema.since((VersionedFeature)SharedSessionConfigSchema.VERSION_2_0)) break;
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    result.setDistributable(true);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

