/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.util.CLIExpressionResolver;

public class EchoVariableHandler
extends CommandHandlerWithHelp {
    public EchoVariableHandler() {
        super("echo");
        new ArgumentWithValue((CommandHandlerWithArguments)this, 0, "--variable");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        int i;
        ParsedCommandLine line = ctx.getParsedCommandLine();
        String result = line.getSubstitutedLine().trim().substring(line.getOperationName().length()).trim();
        if (ctx.isResolveParameterValues()) {
            result = CLIExpressionResolver.resolve(result);
        }
        if ((i = result.indexOf(92)) >= 0) {
            StringBuilder buf = new StringBuilder(result.length() - 1);
            buf.append(result.substring(0, i));
            boolean escaped = true;
            while (++i < result.length()) {
                if (escaped) {
                    buf.append(result.charAt(i));
                    escaped = false;
                    continue;
                }
                char c = result.charAt(i);
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                buf.append(c);
            }
            result = buf.toString();
        }
        ctx.printLine(result);
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        Set<String> propertyNames = args.getPropertyNames();
        if (!propertyNames.isEmpty()) {
            Collection<String> names;
            if (this.helpArg.isPresent(args)) {
                if (propertyNames.size() == 1) {
                    return;
                }
                names = new ArrayList<String>(propertyNames);
                names.remove(this.helpArg.getFullName());
                names.remove(this.helpArg.getShortName());
            } else {
                names = propertyNames;
            }
            throw new CommandFormatException("Unrecognized argument names: " + String.valueOf(names));
        }
    }
}

