/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management.deployment;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.wildfly.extension.core.management.UnstableApiAnnotationResourceDefinition;
import org.wildfly.extension.core.management.deployment.UnstableApiAnnotationAttachments;
import org.wildfly.extension.core.management.logging.CoreManagementLogger;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedAnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedClassUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedFieldReference;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedMethodReference;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ClassInfoScanner;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ExtendsAnnotatedClass;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ImplementsAnnotatedInterface;

public class ReportUnstableApiAnnotationsProcessor
implements DeploymentUnitProcessor {
    private final UnstableApiAnnotationResourceDefinition.UnstableApiAnnotationLevel level;

    public ReportUnstableApiAnnotationsProcessor(UnstableApiAnnotationResourceDefinition.UnstableApiAnnotationLevel level) {
        this.level = level;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        DeploymentUnit top = du.getParent() == null ? du : du.getParent();
        ClassInfoScanner scanner = (ClassInfoScanner)top.getAttachment(UnstableApiAnnotationAttachments.UNSTABLE_API_ANNOTATION_SCANNER);
        if (scanner == null) {
            return;
        }
        CompositeIndex index = (CompositeIndex)du.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        scanner.checkAnnotationIndex(annotationName -> index.getAnnotations(DotName.createSimple((String)annotationName)));
        Set usages = scanner.getUsages();
        if (!usages.isEmpty()) {
            AnnotationUsages annotationUsages = AnnotationUsages.parseAndGroup(scanner.getUsages());
            AnnotationUsageReporter reporter = this.getAnnotationUsageReporter(phaseContext, top);
            if (reporter.isEnabled()) {
                this.reportAnnotationUsages(top, annotationUsages, reporter);
            }
        }
    }

    private void reportAnnotationUsages(DeploymentUnit top, AnnotationUsages annotationUsages, AnnotationUsageReporter reporter) throws DeploymentUnitProcessingException {
        reporter.header(CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.deploymentContainsUnstableApiAnnotations(top.getName()));
        for (ExtendsAnnotatedClass extendsAnnotatedClass : annotationUsages.extendsAnnotatedClasses) {
            reporter.reportAnnotationUsage(CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.classExtendsClassWithUnstableApiAnnotations(extendsAnnotatedClass.getSourceClass(), extendsAnnotatedClass.getSuperClass(), extendsAnnotatedClass.getAnnotations()));
        }
        for (ImplementsAnnotatedInterface implementsAnnotatedInterface : annotationUsages.implementsAnnotatedInterfaces) {
            reporter.reportAnnotationUsage(CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.classImplementsInterfaceWithUnstableApiAnnotations(implementsAnnotatedInterface.getSourceClass(), implementsAnnotatedInterface.getInterface(), implementsAnnotatedInterface.getAnnotations()));
        }
        for (AnnotatedFieldReference annotatedFieldReference : annotationUsages.annotatedFieldReferences) {
            reporter.reportAnnotationUsage(CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.classReferencesFieldWithUnstableApiAnnotations(annotatedFieldReference.getSourceClass(), annotatedFieldReference.getFieldClass(), annotatedFieldReference.getFieldName(), annotatedFieldReference.getAnnotations()));
        }
        for (AnnotatedMethodReference annotatedMethodReference : annotationUsages.annotatedMethodReferences) {
            reporter.reportAnnotationUsage(CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.classReferencesMethodWithUnstableApiAnnotations(annotatedMethodReference.getSourceClass(), annotatedMethodReference.getMethodClass(), annotatedMethodReference.getMethodName(), annotatedMethodReference.getDescriptor(), annotatedMethodReference.getAnnotations()));
        }
        for (AnnotatedClassUsage annotatedClassUsage : annotationUsages.annotatedClassUsages) {
            reporter.reportAnnotationUsage(CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.classReferencesClassWithUnstableApiAnnotations(annotatedClassUsage.getSourceClass(), annotatedClassUsage.getReferencedClass(), annotatedClassUsage.getAnnotations()));
        }
        for (AnnotatedAnnotationUsage annotatedAnnotationUsage : annotationUsages.annotatedAnnotationUsages) {
            reporter.reportAnnotationUsage(CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.classUsesAnnotatedAnnotations(annotatedAnnotationUsage.getClazz(), annotatedAnnotationUsage.getAnnotations()));
        }
        reporter.complete();
    }

    private AnnotationUsageReporter getAnnotationUsageReporter(DeploymentPhaseContext ctx, DeploymentUnit top) throws DeploymentUnitProcessingException {
        if (this.level == UnstableApiAnnotationResourceDefinition.UnstableApiAnnotationLevel.ERROR) {
            return new ErrorAnnotationUsageReporter();
        }
        return new WarningAnnotationUsageReporter();
    }

    private static class AnnotationUsages {
        private final List<ExtendsAnnotatedClass> extendsAnnotatedClasses;
        private final List<ImplementsAnnotatedInterface> implementsAnnotatedInterfaces;
        private final List<AnnotatedFieldReference> annotatedFieldReferences;
        private final List<AnnotatedMethodReference> annotatedMethodReferences;
        private final List<AnnotatedClassUsage> annotatedClassUsages;
        private final List<AnnotatedAnnotationUsage> annotatedAnnotationUsages;

        public AnnotationUsages(List<ExtendsAnnotatedClass> extendsAnnotatedClasses, List<ImplementsAnnotatedInterface> implementsAnnotatedInterfaces, List<AnnotatedFieldReference> annotatedFieldReferences, List<AnnotatedMethodReference> annotatedMethodReferences, List<AnnotatedClassUsage> annotatedClassUsages, List<AnnotatedAnnotationUsage> annotatedAnnotationUsages) {
            this.extendsAnnotatedClasses = extendsAnnotatedClasses;
            this.implementsAnnotatedInterfaces = implementsAnnotatedInterfaces;
            this.annotatedFieldReferences = annotatedFieldReferences;
            this.annotatedMethodReferences = annotatedMethodReferences;
            this.annotatedClassUsages = annotatedClassUsages;
            this.annotatedAnnotationUsages = annotatedAnnotationUsages;
        }

        static AnnotationUsages parseAndGroup(Set<AnnotationUsage> usages) {
            ArrayList<ExtendsAnnotatedClass> extendsAnnotatedClasses = new ArrayList<ExtendsAnnotatedClass>();
            ArrayList<ImplementsAnnotatedInterface> implementsAnnotatedInterfaces = new ArrayList<ImplementsAnnotatedInterface>();
            ArrayList<AnnotatedFieldReference> annotatedFieldReferences = new ArrayList<AnnotatedFieldReference>();
            ArrayList<AnnotatedMethodReference> annotatedMethodReferences = new ArrayList<AnnotatedMethodReference>();
            ArrayList<AnnotatedClassUsage> annotatedClassUsages = new ArrayList<AnnotatedClassUsage>();
            ArrayList<AnnotatedAnnotationUsage> annotatedAnnotationUsages = new ArrayList<AnnotatedAnnotationUsage>();
            for (AnnotationUsage usage : usages) {
                switch (usage.getType()) {
                    case EXTENDS_CLASS: {
                        ExtendsAnnotatedClass ext = usage.asExtendsAnnotatedClass();
                        extendsAnnotatedClasses.add(ext);
                        break;
                    }
                    case IMPLEMENTS_INTERFACE: {
                        ImplementsAnnotatedInterface imp = usage.asImplementsAnnotatedInterface();
                        implementsAnnotatedInterfaces.add(imp);
                        break;
                    }
                    case FIELD_REFERENCE: {
                        AnnotatedFieldReference ref = usage.asAnnotatedFieldReference();
                        annotatedFieldReferences.add(ref);
                        break;
                    }
                    case METHOD_REFERENCE: {
                        AnnotatedFieldReference ref = usage.asAnnotatedMethodReference();
                        annotatedMethodReferences.add((AnnotatedMethodReference)ref);
                        break;
                    }
                    case CLASS_USAGE: {
                        AnnotatedFieldReference ref = usage.asAnnotatedClassUsage();
                        annotatedClassUsages.add((AnnotatedClassUsage)ref);
                        break;
                    }
                    case ANNOTATED_ANNOTATION_USAGE: {
                        AnnotatedFieldReference ref = usage.asAnnotatedAnnotationUsage();
                        annotatedAnnotationUsages.add((AnnotatedAnnotationUsage)ref);
                    }
                }
            }
            extendsAnnotatedClasses.sort(new Comparator<ExtendsAnnotatedClass>(){

                @Override
                public int compare(ExtendsAnnotatedClass o1, ExtendsAnnotatedClass o2) {
                    int i = o1.getSourceClass().compareTo(o2.getSourceClass());
                    if (i == 0) {
                        i = o1.getSuperClass().compareTo(o2.getSuperClass());
                    }
                    return i;
                }
            });
            implementsAnnotatedInterfaces.sort(new Comparator<ImplementsAnnotatedInterface>(){

                @Override
                public int compare(ImplementsAnnotatedInterface o1, ImplementsAnnotatedInterface o2) {
                    int i = o1.getSourceClass().compareTo(o2.getSourceClass());
                    if (i == 0) {
                        i = o1.getInterface().compareTo(o2.getInterface());
                    }
                    return i;
                }
            });
            annotatedFieldReferences.sort(new Comparator<AnnotatedFieldReference>(){

                @Override
                public int compare(AnnotatedFieldReference o1, AnnotatedFieldReference o2) {
                    int i = o1.getSourceClass().compareTo(o2.getSourceClass());
                    if (i == 0 && (i = o1.getFieldClass().compareTo(o2.getFieldClass())) == 0) {
                        i = o1.getFieldName().compareTo(o2.getFieldName());
                    }
                    return i;
                }
            });
            annotatedMethodReferences.sort(new Comparator<AnnotatedMethodReference>(){

                @Override
                public int compare(AnnotatedMethodReference o1, AnnotatedMethodReference o2) {
                    int i = o1.getSourceClass().compareTo(o2.getSourceClass());
                    if (i == 0 && (i = o1.getMethodClass().compareTo(o2.getMethodClass())) == 0 && (i = o1.getMethodName().compareTo(o2.getMethodName())) == 0) {
                        i = o1.getDescriptor().compareTo(o2.getDescriptor());
                    }
                    return i;
                }
            });
            annotatedClassUsages.sort(new Comparator<AnnotatedClassUsage>(){

                @Override
                public int compare(AnnotatedClassUsage o1, AnnotatedClassUsage o2) {
                    int i = o1.getSourceClass().compareTo(o2.getSourceClass());
                    if (i == 0) {
                        i = o1.getReferencedClass().compareTo(o2.getReferencedClass());
                    }
                    return i;
                }
            });
            annotatedAnnotationUsages.sort(new Comparator<AnnotatedAnnotationUsage>(){

                @Override
                public int compare(AnnotatedAnnotationUsage o1, AnnotatedAnnotationUsage o2) {
                    return o1.getClazz().compareTo(o2.getClazz());
                }
            });
            return new AnnotationUsages(extendsAnnotatedClasses, implementsAnnotatedInterfaces, annotatedFieldReferences, annotatedMethodReferences, annotatedClassUsages, annotatedAnnotationUsages);
        }
    }

    private static interface AnnotationUsageReporter {
        public void header(String var1);

        public void reportAnnotationUsage(String var1);

        public void complete() throws DeploymentUnitProcessingException;

        public boolean isEnabled();
    }

    private class ErrorAnnotationUsageReporter
    implements AnnotationUsageReporter {
        private final StringBuilder sb = new StringBuilder();

        private ErrorAnnotationUsageReporter() {
        }

        @Override
        public void header(String message) {
            this.sb.append(message);
        }

        @Override
        public void reportAnnotationUsage(String message) {
            this.sb.append("\n");
            this.sb.append("-");
            this.sb.append(message);
        }

        @Override
        public void complete() throws DeploymentUnitProcessingException {
            throw new DeploymentUnitProcessingException(this.sb.toString());
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private class WarningAnnotationUsageReporter
    implements AnnotationUsageReporter {
        private WarningAnnotationUsageReporter() {
        }

        @Override
        public void header(String message) {
            CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.warn(message);
        }

        @Override
        public void reportAnnotationUsage(String message) {
            CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.warn(message);
        }

        @Override
        public void complete() throws DeploymentUnitProcessingException {
        }

        @Override
        public boolean isEnabled() {
            return CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.isEnabled(Logger.Level.WARN);
        }
    }
}

