/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.service;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.as.server.suspend.SuspensionStateProvider;
import org.wildfly.clustering.server.service.Service;

public class SuspendableService
implements Service,
SuspendableActivity {
    private final Service service;
    private final SuspendableActivityRegistry registry;
    private final Executor executor;

    public SuspendableService(Service service, SuspendableActivityRegistry registry, Executor executor) {
        this.service = service;
        this.registry = registry;
        this.executor = executor;
    }

    public boolean isStarted() {
        return this.service.isStarted();
    }

    public void start() {
        this.registry.registerActivity((SuspendableActivity)this);
        if (this.registry.getState() == SuspensionStateProvider.State.RUNNING) {
            this.service.start();
        }
    }

    public void stop() {
        if (this.registry.getState() == SuspensionStateProvider.State.RUNNING) {
            this.service.stop();
        }
        this.registry.unregisterActivity((SuspendableActivity)this);
    }

    public CompletionStage<Void> suspend(ServerSuspendContext context) {
        return this.service.isStarted() ? CompletableFuture.runAsync(() -> ((Service)this.service).stop(), this.executor) : SuspendableActivity.COMPLETED;
    }

    public CompletionStage<Void> resume(ServerResumeContext context) {
        return !this.service.isStarted() ? CompletableFuture.runAsync(() -> ((Service)this.service).start(), this.executor) : SuspendableActivity.COMPLETED;
    }
}

