/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.cxf.helpers.IOUtils;

public class ImageDataContentHandler
implements DataContentHandler {
    private static final ActivationDataFlavor[] FLAVORS;

    public Object getContent(DataSource ds) throws IOException {
        return ImageIO.read(ds.getInputStream());
    }

    public Object getTransferData(ActivationDataFlavor df, DataSource ds) throws IOException {
        for (ActivationDataFlavor f : FLAVORS) {
            if (!f.equals(df)) continue;
            return this.getContent(ds);
        }
        return null;
    }

    public ActivationDataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (obj instanceof Image) {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mimeType);
            if (writers.hasNext()) {
                ImageWriter writer = writers.next();
                try (ImageOutputStream out = ImageIO.createImageOutputStream(os);){
                    writer.setOutput(out);
                    BufferedImage bimg = ImageDataContentHandler.convertToBufferedImage((Image)obj);
                    writer.write(bimg);
                    out.flush();
                }
                finally {
                    writer.dispose();
                }
                return;
            }
        } else if (obj instanceof byte[]) {
            os.write((byte[])obj);
        } else if (obj instanceof InputStream) {
            IOUtils.copyAndCloseInput((InputStream)obj, os);
        } else if (obj instanceof File) {
            InputStream file = Files.newInputStream(((File)obj).toPath(), new OpenOption[0]);
            IOUtils.copyAndCloseInput(file, os);
        } else {
            throw new IOException("Attachment type not spported " + String.valueOf(obj.getClass()));
        }
    }

    private static BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(new Component(){
            private static final long serialVersionUID = 977142547536262901L;
        });
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufImage;
    }

    static {
        String[] types = ImageIO.getReaderMIMETypes();
        FLAVORS = new ActivationDataFlavor[types.length];
        int i = 0;
        for (String type : types) {
            ImageDataContentHandler.FLAVORS[i++] = new ActivationDataFlavor(Image.class, type, "Image");
        }
    }
}

