/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.DoubleSupplier;
import org.wildfly.clustering.function.LongSupplier;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.function.Supplier;

public interface IntSupplier
extends java.util.function.IntSupplier {
    public static final IntSupplier MINIMUM = IntSupplier.of(Integer.MIN_VALUE);
    public static final IntSupplier ZERO = IntSupplier.of(0);
    public static final IntSupplier MAXIMUM = IntSupplier.of(Integer.MAX_VALUE);

    default public Runnable thenAccept(final IntConsumer consumer) {
        return new Runnable(){
            final /* synthetic */ IntSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                consumer.accept(this.this$0.getAsInt());
            }
        };
    }

    default public <V> Supplier<V> thenApply(final IntFunction<V> function) {
        return new Supplier<V>(this){
            final /* synthetic */ IntSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public V get() {
                return function.apply(this.this$0.getAsInt());
            }
        };
    }

    default public DoubleSupplier thenApplyAsDouble(final IntToDoubleFunction function) {
        return new DoubleSupplier(){
            final /* synthetic */ IntSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public double getAsDouble() {
                return function.applyAsDouble(this.this$0.getAsInt());
            }
        };
    }

    default public IntSupplier thenApplyAsInt(final IntUnaryOperator operator) {
        return new IntSupplier(){
            final /* synthetic */ IntSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int getAsInt() {
                return operator.applyAsInt(this.this$0.getAsInt());
            }
        };
    }

    default public LongSupplier thenApplyAsLong(final IntToLongFunction function) {
        return new LongSupplier(){
            final /* synthetic */ IntSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public long getAsLong() {
                return function.applyAsLong(this.this$0.getAsInt());
            }
        };
    }

    default public BooleanSupplier thenTest(final IntPredicate predicate) {
        return new BooleanSupplier(){
            final /* synthetic */ IntSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean getAsBoolean() {
                return predicate.test(this.this$0.getAsInt());
            }
        };
    }

    default public Supplier<Integer> boxed() {
        return this.thenApply(Integer::valueOf);
    }

    default public IntSupplier handle(final ToIntFunction<RuntimeException> handler) {
        return new IntSupplier(){
            final /* synthetic */ IntSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int getAsInt() {
                try {
                    return this.this$0.getAsInt();
                }
                catch (RuntimeException e) {
                    return handler.applyAsInt(e);
                }
            }
        };
    }

    public static IntSupplier of(final int value) {
        return new IntSupplier(){

            @Override
            public int getAsInt() {
                return value;
            }
        };
    }
}

