/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistrar;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.function.Consumer;

public class SchedulerTopologyChangeListenerRegistrar<K, V, SE, CE>
implements ListenerRegistrar {
    private static final System.Logger LOGGER = System.getLogger(SchedulerTopologyChangeListenerRegistrar.class.getName());
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(SchedulerTopologyChangeListenerRegistrar.class, AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return SchedulerTopologyChangeListenerRegistrar.class.getClassLoader();
        }
    }));
    private final Configuration<K, V, SE, CE> configuration;

    public SchedulerTopologyChangeListenerRegistrar(Configuration<K, V, SE, CE> configuration) {
        this.configuration = configuration;
    }

    public ListenerRegistration register() {
        Cache cache = this.configuration.getCacheConfiguration().getCache();
        TopologyChangedListener listener = new TopologyChangedListener(this.configuration);
        cache.addListener(listener);
        return () -> {
            cache.removeListener((Object)listener);
            Consumer.close().accept((Object)listener);
        };
    }

    static interface Configuration<K, V, SE, CE> {
        public EmbeddedCacheConfiguration getCacheConfiguration();

        public java.util.function.Consumer<CacheStreamFilter<SE>> getScheduleTask();

        public java.util.function.Consumer<CacheStreamFilter<CE>> getCancelTask();
    }

    @Listener
    static class TopologyChangedListener<K, V, SE, CE>
    implements AutoCloseable {
        private final ExecutorService executor = Executors.newSingleThreadExecutor(THREAD_FACTORY);
        private final java.util.function.Consumer<CacheStreamFilter<SE>> scheduleTask;
        private final java.util.function.Consumer<CacheStreamFilter<CE>> cancelTask;
        private final Duration stopTimeout;

        TopologyChangedListener(Configuration<K, V, SE, CE> configuration) {
            this.scheduleTask = configuration.getScheduleTask();
            this.cancelTask = configuration.getCancelTask();
            this.stopTimeout = configuration.getCacheConfiguration().getStopTimeout();
        }

        @TopologyChanged
        public CompletionStage<Void> topologyChanged(TopologyChangedEvent<K, V> event) {
            Cache cache = event.getCache();
            Address address = cache.getCacheManager().getAddress();
            ConsistentHash oldHash = event.getWriteConsistentHashAtStart();
            Set oldSegments = oldHash.getMembers().contains(address) ? oldHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
            ConsistentHash newHash = event.getWriteConsistentHashAtEnd();
            Set newSegments = newHash.getMembers().contains(address) ? newHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
            LOGGER.log(System.Logger.Level.DEBUG, "{0} scheduler topology change listener received {1}-topology changed event: {2} -> {3}", cache.getName(), event.isPre() ? "pre" : "post", oldHash.getMembers(), newHash.getMembers());
            if (event.isPre()) {
                if (!oldSegments.isEmpty()) {
                    IntSet formerlyOwnedSegments = IntSets.mutableCopyFrom((Set)oldSegments);
                    formerlyOwnedSegments.removeAll(IntSets.from((Set)newSegments));
                    if (!formerlyOwnedSegments.isEmpty()) {
                        try {
                            LOGGER.log(System.Logger.Level.DEBUG, "{0} cancelling scheduled entries for formerly owned segments: {1}", cache.getName(), formerlyOwnedSegments);
                            this.executor.execute(() -> this.cancelTask.accept(CacheStreamFilter.segments((IntSet)formerlyOwnedSegments)));
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {}
                    }
                }
            } else if (!newSegments.isEmpty()) {
                IntSet newlyOwnedSegments = IntSets.mutableCopyFrom((Set)newSegments);
                newlyOwnedSegments.removeAll(IntSets.from((Set)oldSegments));
                if (!newlyOwnedSegments.isEmpty()) {
                    try {
                        LOGGER.log(System.Logger.Level.DEBUG, "{0} scheduling entries for newly owned segments: {1}", cache.getName(), newlyOwnedSegments);
                        this.executor.execute(() -> this.scheduleTask.accept(CacheStreamFilter.segments((IntSet)newlyOwnedSegments)));
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
            return CompletableFuture.completedStage(null);
        }

        @Override
        public void close() {
            final ExecutorService executor = this.executor;
            final Duration stopTimeout = this.stopTimeout;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                final /* synthetic */ TopologyChangedListener this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void run() {
                    try {
                        executor.shutdownNow();
                        executor.awaitTermination(stopTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    return null;
                }
            });
        }
    }
}

