/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.provider;

import java.util.List;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrar;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.extension.clustering.server.provider.ServiceProviderRegistrarServiceInstallerFactory;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheServiceProviderRegistrarServiceInstallerFactory<T>
extends ServiceProviderRegistrarServiceInstallerFactory<T> {
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency group = configuration.getServiceDependency(ClusteringServiceDescriptor.GROUP).map(CacheContainerGroup.class::cast);
        final ServiceDependency cache = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        ServiceName name = configuration.resolveServiceName(this.getServiceDescriptor());
        final CacheServiceProviderRegistrar.Configuration config = new CacheServiceProviderRegistrar.Configuration(){

            public <K, V> Cache<K, V> getCache() {
                return (Cache)cache.get();
            }

            public CacheContainerGroup getGroup() {
                return (CacheContainerGroup)group.get();
            }
        };
        Supplier<CacheServiceProviderRegistrar<Object>> factory = new Supplier<CacheServiceProviderRegistrar<Object>>(){

            @Override
            public CacheServiceProviderRegistrar<Object> get() {
                return new CacheServiceProviderRegistrar(config);
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).blocking()).provides(name)).requires(List.of(group, cache))).onStop((java.util.function.Consumer)Consumer.close())).build();
    }
}

