/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.embedded;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.server.ElapsedTime;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.core.embedded.spi.BootstrappedEmbeddedProcess;
import org.wildfly.core.embedded.spi.EmbeddedModelControllerClientFactory;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrap;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrapConfiguration;
import org.wildfly.core.embedded.spi.ProcessStateNotifier;

public abstract class AbstractEmbeddedProcessBootstrap
implements EmbeddedProcessBootstrap {
    public BootstrappedEmbeddedProcess startup(final EmbeddedProcessBootstrapConfiguration configuration) throws Exception {
        ElapsedTime elapsedTime = ElapsedTime.startingFromNow();
        SystemExiter.initialize(new SystemExiter.Exiter(){

            @Override
            public void exit(int status) {
                configuration.getSystemExitCallback().accept(status);
            }
        });
        CountDownLatch serviceAwait = new CountDownLatch(2);
        AtomicReference notifierRef = new AtomicReference();
        ServiceActivator notifierCapture = ctx -> AbstractEmbeddedProcessBootstrap.captureValue(ctx, ProcessStateNotifier.SERVICE_NAME, new CountdownConsumer(serviceAwait, notifierRef));
        final AtomicReference clientFactoryRef = new AtomicReference();
        ServiceActivator clientFactoryCapture = ctx -> AbstractEmbeddedProcessBootstrap.captureValue(ctx, EmbeddedModelControllerClientFactory.SERVICE_NAME, new CountdownConsumer(serviceAwait, clientFactoryRef));
        Future<ServiceContainer> future = this.bootstrapEmbeddedProcess(elapsedTime, configuration, notifierCapture, clientFactoryCapture);
        if (future == null) {
            return null;
        }
        final ServiceContainer serviceContainer = future.get();
        try {
            if (!serviceAwait.await(30L, TimeUnit.SECONDS)) {
                StringBuilder sb = new StringBuilder();
                ProcessStateNotifier psn = (ProcessStateNotifier)notifierRef.get();
                if (psn == null) {
                    sb.append(ProcessStateNotifier.class.getSimpleName());
                }
                if (clientFactoryRef.get() == null) {
                    if (psn == null) {
                        sb.append(" ");
                    }
                    sb.append(EmbeddedModelControllerClientFactory.class.getSimpleName());
                }
                ServerLogger.ROOT_LOGGER.embeddedProcessServicesUnavailable(30, sb.toString());
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
        final ProcessStateNotifier psn = (ProcessStateNotifier)notifierRef.get();
        return new BootstrappedEmbeddedProcess(){

            public ServiceContainer getServiceContainer() {
                return serviceContainer;
            }

            public ProcessStateNotifier getProcessStateNotifier() {
                return psn;
            }

            public EmbeddedModelControllerClientFactory getModelControllerClientFactory() {
                return (EmbeddedModelControllerClientFactory)clientFactoryRef.get();
            }

            public void close() {
                SystemExiter.initialize(SystemExiter.Exiter.DEFAULT);
            }
        };
    }

    protected abstract Future<ServiceContainer> bootstrapEmbeddedProcess(ElapsedTime var1, EmbeddedProcessBootstrapConfiguration var2, ServiceActivator ... var3) throws Exception;

    private static <T> void captureValue(ServiceActivatorContext ctx, ServiceName toCapture, final Consumer<T> captor) {
        ServiceBuilder sb = ctx.getServiceTarget().addService();
        final Supplier result = sb.requires(toCapture);
        sb.setInstance(new Service(){

            public void start(StartContext context) {
                captor.accept(result.get());
                context.getController().setMode(ServiceController.Mode.REMOVE);
            }

            public void stop(StopContext context) {
            }
        });
        sb.install();
    }

    private static class CountdownConsumer<T>
    implements Consumer<T> {
        private final CountDownLatch latch;
        private final AtomicReference<T> reference;

        private CountdownConsumer(CountDownLatch latch, AtomicReference<T> reference) {
            this.latch = latch;
            this.reference = reference;
        }

        @Override
        public void accept(T t) {
            this.reference.set(t);
            this.latch.countDown();
        }
    }
}

