/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import jakarta.batch.operations.JobOperator;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import org.jberet._private.BatchLogger;
import org.jberet.creation.BatchBeanProducer;
import org.jberet.creation.JobOperatorProducer;
import org.jberet.creation.JobScopedContextImpl;
import org.jberet.creation.PartitionScopedContextImpl;
import org.jberet.creation.StepScopedContextImpl;

public class BatchCDIExtension
implements Extension {
    private Boolean applicationDefinedJobOperatorProducer;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType batchProducerAnnotatedType = beanManager.createAnnotatedType(BatchBeanProducer.class);
        beforeBeanDiscovery.addAnnotatedType(batchProducerAnnotatedType, BatchBeanProducer.class.getName());
    }

    public void addContext(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        afterBeanDiscovery.addContext((Context)JobScopedContextImpl.INSTANCE);
        afterBeanDiscovery.addContext((Context)StepScopedContextImpl.INSTANCE);
        afterBeanDiscovery.addContext((Context)PartitionScopedContextImpl.INSTANCE);
    }

    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        Bean bean;
        if (this.applicationDefinedJobOperatorProducer == null && (bean = processBeanEvent.getBean()).getTypes().contains(JobOperator.class)) {
            if (bean.getBeanClass() == JobOperatorProducer.class) {
                this.applicationDefinedJobOperatorProducer = Boolean.FALSE;
            } else {
                this.applicationDefinedJobOperatorProducer = Boolean.TRUE;
                if (BatchLogger.LOGGER.isDebugEnabled()) {
                    BatchLogger.LOGGER.debugf("Use application-defined JobOperator producer: %s", bean.getBeanClass());
                }
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        if (this.applicationDefinedJobOperatorProducer == null) {
            abd.addBean((Bean)new JobOperatorProducer());
        }
    }
}

