/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.merge.javaee.spec;

import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DataSourcesMetaData;
import org.jboss.metadata.merge.javaee.spec.DataSourceMetaDataMerger;

public class DataSourcesMetaDataMerger {
    public static DataSourcesMetaData merge(DataSourcesMetaData override, DataSourcesMetaData overriden, String overridenFile, String overrideFile) {
        if (override == null && overriden == null) {
            return null;
        }
        if (override == null) {
            return overriden;
        }
        DataSourcesMetaData merged = new DataSourcesMetaData();
        return DataSourcesMetaDataMerger.merge(merged, overriden, override, "data-source", overridenFile, overrideFile, false);
    }

    private static DataSourcesMetaData merge(DataSourcesMetaData merged, DataSourcesMetaData overriden, DataSourcesMetaData mapped, String context, String overridenFile, String overrideFile, boolean mustOverride) {
        String key;
        if (merged == null) {
            throw new IllegalArgumentException("Null merged");
        }
        if (overriden == null && mapped == null) {
            return merged;
        }
        if (overriden == null || overriden.isEmpty()) {
            if (mapped == null) {
                return merged;
            }
            if (!mapped.isEmpty() && mustOverride) {
                throw new IllegalStateException(overridenFile + " has no " + context + "s but " + overrideFile + " has " + String.valueOf(mapped.keySet()));
            }
            if (mapped != merged) {
                merged.addAll(mapped);
            }
            return merged;
        }
        for (DataSourceMetaData original : overriden) {
            key = original.getKey();
            if (mapped != null && mapped.containsKey(key)) {
                DataSourceMetaData override = (DataSourceMetaData)mapped.get(key);
                DataSourceMetaData tnew = DataSourceMetaDataMerger.merge(override, original);
                merged.add(tnew);
                continue;
            }
            merged.add(original);
        }
        if (mapped != null) {
            for (DataSourceMetaData override : mapped) {
                key = override.getKey();
                if (merged.containsKey(key)) continue;
                if (mustOverride) {
                    throw new IllegalStateException(key + " in " + overrideFile + ", but not in " + overridenFile);
                }
                merged.add(override);
            }
        }
        return merged;
    }

    public static void augment(DataSourcesMetaData dest, DataSourcesMetaData webFragmentMetaData, DataSourcesMetaData webMetaData, boolean resolveConflicts) {
        for (DataSourceMetaData dataSourceMetaData : webFragmentMetaData) {
            if (dest.containsKey(dataSourceMetaData.getKey())) {
                if (resolveConflicts || webMetaData != null && webMetaData.containsKey(dataSourceMetaData.getKey())) continue;
                throw new IllegalStateException("Unresolved conflict on data source named: " + dataSourceMetaData.getKey());
            }
            dest.add(dataSourceMetaData);
        }
    }
}

