/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.impl.TagReaderImpl;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamSizeOperation;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class ProtoStreamByteBufferMarshaller
implements ByteBufferMarshaller {
    private final ImmutableSerializationContext context;

    public ProtoStreamByteBufferMarshaller(ImmutableSerializationContext context) {
        this.context = context;
    }

    public OptionalInt size(Object object) {
        DefaultProtoStreamSizeOperation operation = new DefaultProtoStreamSizeOperation(this.context);
        ProtoStreamMarshaller marshaller = operation.findMarshaller(Any.class);
        return marshaller.size(operation, new Any(object));
    }

    public boolean test(Object object) {
        if (object == null || object instanceof Class) {
            return true;
        }
        Class<?> targetClass = object.getClass();
        if (AnyField.fromJavaType(targetClass) != null) {
            return true;
        }
        if (targetClass.isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (this.test(Array.get(object, i))) continue;
                return false;
            }
            return true;
        }
        if (Proxy.isProxyClass(targetClass)) {
            return this.test(Proxy.getInvocationHandler(object));
        }
        while (targetClass != null) {
            if (this.context.canMarshall(targetClass)) {
                return true;
            }
            targetClass = targetClass.getSuperclass();
        }
        return false;
    }

    public Object readFrom(InputStream input) throws IOException {
        TagReaderImpl context = TagReaderImpl.newInstance((ImmutableSerializationContext)this.context, (InputStream)input);
        DefaultProtoStreamReader reader = new DefaultProtoStreamReader((ProtobufTagMarshaller.ReadContext)context);
        ProtoStreamMarshaller marshaller = reader.findMarshaller(Any.class);
        return ((Any)marshaller.readFrom(reader)).get();
    }

    public void writeTo(OutputStream output, Object object) throws IOException {
        TagWriterImpl context = TagWriterImpl.newInstance((ImmutableSerializationContext)this.context, (OutputStream)output);
        DefaultProtoStreamWriter writer = new DefaultProtoStreamWriter((ProtobufTagMarshaller.WriteContext)context);
        ProtoStreamMarshaller marshaller = writer.findMarshaller(Any.class);
        marshaller.writeTo(writer, new Any(object));
    }

    public String toString() {
        return "ProtoStream";
    }
}

