/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.Property;

public enum PropertiesMarshaller implements ProtoStreamMarshaller<Properties>
{
    INSTANCE;

    private static final int PROPERTY_INDEX = 1;

    @Override
    public Class<? extends Properties> getJavaClass() {
        return Properties.class;
    }

    @Override
    public Properties readFrom(ProtoStreamReader reader) throws IOException {
        Properties properties = new Properties();
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    Map.Entry entry = reader.readObject(Property.class);
                    properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return properties;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Properties properties) throws IOException {
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            writer.writeObject(1, new Property(key, value));
        }
    }
}

