/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.execution.spi;

import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public interface SimpleScheduledExecutor {
    public Future<?> submit(Runnable var1);

    public ScheduledFuture<?> schedule(Runnable var1, long var2, TimeUnit var4);

    default public Future<?> offer(Runnable task) {
        if (this.isBlocking()) {
            throw new RejectedExecutionException(String.format(Locale.ROOT, "Unable to accept '%1$s' task for execution. '%2$s' is a blocking executor and it does not implement `SimpleScheduledExecutor#offer(Runnable)`.", task, this));
        }
        return this.submit(task);
    }

    public void shutdownNow();

    public boolean isBlocking();
}

