/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.io.IOException;
import java.time.Duration;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;

public enum DefaultSessionAccessMetaDataEntryMarshaller implements ProtoStreamMarshaller<DefaultSessionAccessMetaDataEntry>
{
    INSTANCE;

    private static final Duration DEFAULT_SINCE_CREATION;
    private static final Duration DEFAULT_LAST_ACCESS;
    private static final int SINCE_CREATION_INDEX = 1;
    private static final int LAST_ACCESS_INDEX = 2;

    public DefaultSessionAccessMetaDataEntry readFrom(ProtoStreamReader reader) throws IOException {
        Duration sinceCreation = DEFAULT_SINCE_CREATION;
        Duration lastAccess = DEFAULT_LAST_ACCESS;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    sinceCreation = (Duration)reader.readObject(Duration.class);
                    continue block4;
                }
                case 2: {
                    lastAccess = (Duration)reader.readObject(Duration.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        DefaultSessionAccessMetaDataEntry metaData = new DefaultSessionAccessMetaDataEntry();
        metaData.setLastAccessDuration(sinceCreation, lastAccess);
        return metaData;
    }

    public void writeTo(ProtoStreamWriter writer, DefaultSessionAccessMetaDataEntry metaData) throws IOException {
        Duration lastAccess;
        Duration sinceCreation = metaData.getSinceCreationDuration();
        if (!sinceCreation.equals(DEFAULT_SINCE_CREATION)) {
            writer.writeObject(1, (Object)sinceCreation);
        }
        if (!(lastAccess = metaData.getLastAccessDuration()).equals(DEFAULT_LAST_ACCESS)) {
            writer.writeObject(2, (Object)lastAccess);
        }
    }

    public Class<? extends DefaultSessionAccessMetaDataEntry> getJavaClass() {
        return DefaultSessionAccessMetaDataEntry.class;
    }

    static {
        DEFAULT_SINCE_CREATION = Duration.ZERO;
        DEFAULT_LAST_ACCESS = Duration.ofSeconds(1L);
    }
}

