/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.validation.PatchHistoryIterator;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactStateHandler;
import org.jboss.as.patching.validation.PatchingArtifacts;
import org.jboss.as.patching.validation.PatchingValidationErrorHandler;

public final class PatchHistoryValidations {
    private PatchHistoryValidations() {
    }

    public static void validateRollbackState(String patchID, InstalledIdentity identity) throws PatchingException {
        Set<String> validHistory = PatchHistoryValidations.processRollbackState(patchID, identity);
        if (patchID != null && !validHistory.contains(patchID)) {
            throw PatchLogger.ROOT_LOGGER.patchNotFoundInHistory(patchID);
        }
    }

    private static Set<String> processRollbackState(final String patchID, InstalledIdentity identity) throws PatchingException {
        final HashSet<String> validHistory = new HashSet<String>();
        PatchHistoryIterator.Builder builder = PatchHistoryIterator.Builder.create(identity);
        HistoryProcessor processor = new HistoryProcessor(){
            boolean includeCurrent = true;
            boolean proceed = true;
            boolean found = false;

            @Override
            protected boolean includeCurrent() {
                return this.includeCurrent;
            }

            @Override
            protected boolean canProceed() {
                return this.proceed;
            }

            @Override
            protected <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> boolean handleError(PatchingArtifact<P, S> artifact, S state) {
                if (artifact == PatchingArtifacts.HISTORY_DIR || artifact == PatchingArtifacts.PATCH_XML || artifact == PatchingArtifacts.ROLLBACK_XML || artifact == PatchingArtifacts.MISC_BACKUP) {
                    this.proceed = false;
                    return this.found;
                }
                this.includeCurrent = false;
                this.proceed = false;
                return false;
            }

            @Override
            protected void processedPatch(String patch) {
                validHistory.add(patch);
                if (patch.equals(patchID)) {
                    this.found = true;
                } else if (this.found) {
                    this.proceed = false;
                }
            }
        };
        processor.process(builder.iterator());
        return validHistory;
    }

    static abstract class HistoryProcessor
    implements PatchingValidationErrorHandler {
        private final List<String> errors = new ArrayList<String>();

        HistoryProcessor() {
        }

        protected abstract boolean includeCurrent();

        protected abstract boolean canProceed();

        protected abstract <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> boolean handleError(PatchingArtifact<P, S> var1, S var2);

        protected abstract void processedPatch(String var1);

        @Override
        public <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> void addError(PatchingArtifact<P, S> artifact, S state) {
            if (!this.handleError(artifact, state)) {
                this.errors.add(PatchLogger.ROOT_LOGGER.artifactInError(state));
            }
        }

        @Override
        public <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> void addInconsistent(PatchingArtifact<P, S> artifact, S current) {
            if (!this.handleError(artifact, current)) {
                this.errors.add(PatchLogger.ROOT_LOGGER.inconsistentArtifact(current));
            }
        }

        @Override
        public <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> void addMissing(PatchingArtifact<P, S> artifact, S state) {
            if (!this.handleError(artifact, state)) {
                this.errors.add(PatchLogger.ROOT_LOGGER.missingArtifact(state));
            }
        }

        protected void process(PatchHistoryIterator iterator) throws PatchingException {
            while (iterator.hasNext() && this.canProceed()) {
                String patch = iterator.next(this);
                if (!this.includeCurrent()) continue;
                this.processedPatch(patch);
            }
            if (!this.errors.isEmpty()) {
                throw new PatchingException(this.errors.toString());
            }
        }
    }

    static class PatchingArtifactStateHandlers {
        private final Map<PatchingArtifact<? extends PatchingArtifact.ArtifactState, ? extends PatchingArtifact.ArtifactState>, PatchingArtifactStateHandler<? extends PatchingArtifact.ArtifactState>> handlers = new HashMap<PatchingArtifact<? extends PatchingArtifact.ArtifactState, ? extends PatchingArtifact.ArtifactState>, PatchingArtifactStateHandler<? extends PatchingArtifact.ArtifactState>>();

        PatchingArtifactStateHandlers() {
        }

        <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> void put(PatchingArtifact<P, S> artifact, PatchingArtifactStateHandler<S> handler) {
            assert (!this.handlers.containsKey(artifact));
            this.handlers.put(artifact, handler);
        }

        <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> PatchingArtifactStateHandler<S> get(PatchingArtifact<P, S> artifact) {
            return this.handlers.get(artifact);
        }
    }
}

