/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import java.time.Year;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum YearMarshaller implements FieldSetMarshaller.Simple<Year>
{
    INSTANCE;

    private static final int POST_EPOCH_YEAR = 0;
    private static final int PRE_EPOCH_YEAR = 1;
    private static final int FIELDS = 2;
    private static final Year EPOCH;

    @Override
    public Year createInitialValue() {
        return EPOCH;
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public Year readFrom(ProtoStreamReader reader, int index, WireType type, Year year) throws IOException {
        return switch (index) {
            case 0 -> Year.of(EPOCH.getValue() + reader.readUInt32());
            case 1 -> Year.of(EPOCH.getValue() - reader.readUInt32());
            default -> (Year)Supplier.call(() -> reader.skipField(type), null).thenApply((Function)org.wildfly.clustering.function.Function.of((Object)year)).get();
        };
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Year value) throws IOException {
        int year = value.getValue();
        if (year > EPOCH.getValue()) {
            writer.writeUInt32(0, year - EPOCH.getValue());
        } else if (year < EPOCH.getValue()) {
            writer.writeUInt32(1, EPOCH.getValue() - year);
        }
    }

    static {
        EPOCH = Year.of(LocalDate.ofEpochDay(0L).getYear());
    }
}

