/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.YearMarshaller;

public enum YearMonthMarshaller implements ProtoStreamMarshaller<YearMonth>
{
    INSTANCE;

    private static final Month[] MONTHS;
    private static final YearMonth DEFAULT;
    private static final int YEAR_INDEX = 1;
    private static final int MONTH_INDEX;

    @Override
    public YearMonth readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<Year> yearReader = reader.createFieldSetReader(YearMarshaller.INSTANCE, 1);
        YearMonth result = DEFAULT;
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (yearReader.contains(index)) {
                result = result.withYear(yearReader.readField(Year.of(result.getYear())).getValue());
                continue;
            }
            if (index == MONTH_INDEX) {
                result = result.withMonth(MONTHS[reader.readEnum()].getValue());
                continue;
            }
            reader.skipField(tag);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, YearMonth value) throws IOException {
        Month month;
        int year = value.getYear();
        if (year != DEFAULT.getYear()) {
            writer.createFieldSetWriter(YearMarshaller.INSTANCE, 1).writeFields(Year.of(year));
        }
        if ((month = value.getMonth()) != DEFAULT.getMonth()) {
            writer.writeEnum(MONTH_INDEX, month.ordinal());
        }
    }

    @Override
    public Class<? extends YearMonth> getJavaClass() {
        return YearMonth.class;
    }

    static {
        MONTHS = Month.values();
        DEFAULT = YearMonth.of(YearMarshaller.INSTANCE.createInitialValue().getValue(), Month.JANUARY);
        MONTH_INDEX = YearMarshaller.INSTANCE.nextIndex(1);
    }
}

