/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.routing.infinispan;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.infinispan.registry.CacheContainerRegistry;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.web.service.deployment.WebDeploymentConfiguration;
import org.wildfly.clustering.web.service.deployment.WebDeploymentServiceDescriptor;
import org.wildfly.extension.clustering.web.routing.LocalRouteLocatorProvider;
import org.wildfly.service.Dependency;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class InfinispanRouteLocatorProvider
extends LocalRouteLocatorProvider {
    private final BiFunction<Cache<Key<String>, ?>, CacheContainerRegistry<String, Void>, UnaryOperator<String>> factory;

    InfinispanRouteLocatorProvider(BiFunction<Cache<Key<String>, ?>, CacheContainerRegistry<String, Void>, UnaryOperator<String>> factory) {
        this.factory = factory;
    }

    @Override
    public ServiceInstaller getServiceInstaller(BinaryServiceConfiguration configuration, WebDeploymentConfiguration deployment) {
        final ServiceInstaller localInstaller = super.getServiceInstaller(configuration, deployment);
        DeploymentUnit unit = deployment.getDeploymentUnit();
        final ServiceDependency cacheConfiguration = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION);
        ServiceDependency cache = configuration.withChildName(deployment.getDeploymentName()).getServiceDependency(InfinispanServiceDescriptor.CACHE).map(Cache.class::cast);
        ServiceDependency registry = configuration.withChildName(deployment.getServerName()).getServiceDependency(ClusteringServiceDescriptor.REGISTRY).map(CacheContainerRegistry.class::cast);
        ServiceDependency factory = cache.combine((Dependency)registry, this.factory);
        return (ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)new ServiceInstaller(){
            final /* synthetic */ Supplier val$factory;
            final /* synthetic */ DeploymentUnit val$unit;
            final /* synthetic */ ServiceDependency val$cache;
            final /* synthetic */ ServiceDependency val$registry;
            {
                this.val$factory = supplier;
                this.val$unit = deploymentUnit;
                this.val$cache = serviceDependency2;
                this.val$registry = serviceDependency3;
            }

            public ServiceController<?> install(RequirementServiceTarget target) {
                if (!Configurations.needSegments((Configuration)((Configuration)cacheConfiguration.get()))) {
                    return localInstaller.install((ServiceTarget)target);
                }
                return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)this.val$factory).provides(WebDeploymentServiceDescriptor.ROUTE_LOCATOR.resolve(this.val$unit))).requires(List.of(this.val$cache, this.val$registry))).build()).install((ServiceTarget)target);
            }
        }, (CapabilityServiceSupport)((CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT))).requires((Consumer)cacheConfiguration)).build();
    }
}

