/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq.client;

import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.AddressQueryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQConsumerContext;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQSessionContext;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.TokenBucketLimiterImpl;

public class HornetQClientSessionContext
extends ActiveMQSessionContext {
    public HornetQClientSessionContext(String name, RemotingConnection remotingConnection, Channel sessionChannel, int serverVersion, int confirmationWindow) {
        super(name, remotingConnection, sessionChannel, serverVersion, confirmationWindow);
    }

    @Override
    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws ActiveMQException {
        SessionQueueQueryMessage request = new SessionQueueQueryMessage(queueName);
        SessionQueueQueryResponseMessage response = (SessionQueueQueryResponseMessage)this.getSessionChannel().sendBlocking(request, (byte)46);
        return response.toQueueQuery();
    }

    @Override
    protected CreateSessionMessage newCreateSession(String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) {
        return new CreateSessionMessage(this.getName(), this.getSessionChannel().getID(), 123, username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.getConfirmationWindow(), null);
    }

    @Override
    public ClientSession.AddressQuery addressQuery(SimpleString address) throws ActiveMQException {
        SessionBindingQueryResponseMessage response = (SessionBindingQueryResponseMessage)this.getSessionChannel().sendBlocking(new SessionBindingQueryMessage(address), (byte)50);
        return new AddressQueryImpl(response.isExists(), response.getQueueNames(), false, false, ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), ActiveMQDefaultConfiguration.getDefaultExclusive(), ActiveMQDefaultConfiguration.getDefaultLastValue(), ActiveMQDefaultConfiguration.getDefaultLastValueKey(), ActiveMQDefaultConfiguration.getDefaultNonDestructive(), ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch(), ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch(), true, true);
    }

    @Override
    public ClientConsumerInternal createConsumer(SimpleString queueName, SimpleString filterString, int priority, int windowSize, int maxRate, int ackBatchSize, boolean browseOnly, Executor executor, Executor flowControlExecutor, int onMessageCloseTimeout) throws ActiveMQException {
        long consumerID = this.idGenerator.generateID();
        ActiveMQConsumerContext consumerContext = new ActiveMQConsumerContext(consumerID);
        SessionCreateConsumerMessage request = new SessionCreateConsumerMessage(consumerID, queueName, filterString, priority, browseOnly, true);
        SessionQueueQueryResponseMessage queueInfo = (SessionQueueQueryResponseMessage)this.getSessionChannel().sendBlocking(request, (byte)46);
        return new ClientConsumerImpl(this.session, consumerContext, queueName, filterString, priority, browseOnly, windowSize, this.calcWindowSize(windowSize), ackBatchSize, maxRate > 0 ? new TokenBucketLimiterImpl(maxRate, false) : null, executor, flowControlExecutor, this, queueInfo.toQueueQuery(), this.lookupTCCL(), onMessageCloseTimeout);
    }
}

