/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.manager;

import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;

public class AffinityIdentifierFactoryService<I>
implements IdentifierFactoryService<I>,
KeyGenerator<Key<I>> {
    private final Supplier<I> factory;
    private final KeyAffinityService<? extends Key<I>> affinity;
    private final Address localAddress;

    public AffinityIdentifierFactoryService(Supplier<I> factory, Cache<? extends Key<I>, ?> cache) {
        this.factory = factory;
        this.affinity = KeyAffinityServiceFactory.INSTANCE.createService(cache, (KeyGenerator)this);
        this.localAddress = cache.getCacheManager().getAddress();
    }

    public I get() {
        return (I)((Key)this.affinity.getKeyForAddress(this.localAddress)).getId();
    }

    public Key<I> getKey() {
        return new CacheKey(this.factory.get());
    }

    public boolean isStarted() {
        return this.affinity.isStarted();
    }

    public void start() {
        this.affinity.start();
    }

    public void stop() {
        this.affinity.stop();
    }
}

