/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDoohickey;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

abstract class AbstractCredentialStoreResourceDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<CredentialStore> CREDENTIAL_STORE_UTIL = ServiceUtil.newInstance(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, "credential-store", CredentialStore.class);
    static final StandardResourceDescriptionResolver OPERATION_RESOLVER = ElytronExtension.getResourceDescriptionResolver("credential-store", "operations");
    static final SimpleOperationDefinition READ_ALIASES = new SimpleOperationDefinitionBuilder("read-aliases", (ResourceDescriptionResolver)OPERATION_RESOLVER).setRuntimeOnly().setReadOnly().build();
    static final SimpleAttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, false).setMinSize(1)).build();
    static final SimpleAttributeDefinition KEY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key", ModelType.STRING, false).setMinSize(1)).build();
    static final SimpleOperationDefinition EXPORT_SECRET_KEY = new SimpleOperationDefinitionBuilder("export-secret-key", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS}).setRuntimeOnly().build();
    static final SimpleOperationDefinition IMPORT_SECRET_KEY = new SimpleOperationDefinitionBuilder("import-secret-key", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, KEY}).setRuntimeOnly().build();
    static final SimpleOperationDefinition RELOAD = new SimpleOperationDefinitionBuilder("reload", (ResourceDescriptionResolver)OPERATION_RESOLVER).setRuntimeOnly().build();
    static final OperationStepHandler RELOAD_HANDLER = new CredentialStoreReloadHandler();

    protected ServiceUtil<CredentialStore> getCredentialStoreUtil() {
        return CREDENTIAL_STORE_UTIL;
    }

    protected AbstractCredentialStoreResourceDefinition(SimpleResourceDefinition.Parameters parameters) {
        super(parameters);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AttributeDefinition[] configAttributes;
        for (AttributeDefinition current : configAttributes = this.getAttributeDefinitions()) {
            resourceRegistration.registerReadWriteAttribute(current, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
        }
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new ElytronRuntimeOnlyHandler(){

                protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName credentialStoreClientServiceName = AbstractCredentialStoreResourceDefinition.this.getCredentialStoreUtil().serviceName(operation);
                    ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(credentialStoreClientServiceName);
                    ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
                }
            });
        }
    }

    protected abstract AttributeDefinition[] getAttributeDefinitions();

    protected void readAliasesOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        try {
            try {
                ArrayList<ModelNode> list = new ArrayList<ModelNode>();
                Set aliases = credentialStore.getAliases();
                for (String s : aliases) {
                    ModelNode modelNode = new ModelNode(s);
                    list.add(modelNode);
                }
                context.getResult().set(list);
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, AbstractCredentialStoreResourceDefinition.dumpCause(e));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected void removeAliasOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore, Class<? extends Credential> credentialType) throws OperationFailedException {
        try {
            try {
                String alias = ALIAS.resolveModelAttribute(context, operation).asString();
                Credential retrieved = credentialStore.retrieve(alias, credentialType);
                if (retrieved == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(alias, credentialType.getSimpleName());
                }
                credentialStore.remove(alias, credentialType);
                context.addResponseWarning(Level.WARNING, ElytronSubsystemMessages.ROOT_LOGGER.updateDependantServices(alias));
                try {
                    credentialStore.flush();
                }
                catch (CredentialStoreException e) {
                    credentialStore.store(alias, retrieved);
                    throw e;
                }
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, AbstractCredentialStoreResourceDefinition.dumpCause(e));
            }
        }
        catch (RuntimeException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected void exportSecretKeyOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        try {
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            SecretKeyCredential credential = (SecretKeyCredential)credentialStore.retrieve(alias, SecretKeyCredential.class);
            if (credential == null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(alias, SecretKeyCredential.class.getSimpleName());
            }
            SecretKey secretKey = credential.getSecretKey();
            String exportedKey = SecretKeyUtil.exportSecretKey((SecretKey)secretKey);
            ModelNode result = context.getResult();
            result.get("key").set(exportedKey);
        }
        catch (GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.secretKeyOperationFailed("export-secret-key", AbstractCredentialStoreResourceDefinition.dumpCause(e), e);
        }
    }

    protected void importSecretKeyOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        try {
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            String rawKey = KEY.resolveModelAttribute(context, operation).asString();
            if (credentialStore.exists(alias, SecretKeyCredential.class)) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialAlreadyExists(alias, SecretKeyCredential.class.getName());
            }
            SecretKey secretKey = SecretKeyUtil.importSecretKey((String)rawKey);
            AbstractCredentialStoreResourceDefinition.storeSecretKey(credentialStore, alias, secretKey);
        }
        catch (GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.secretKeyOperationFailed("import-secret-key", AbstractCredentialStoreResourceDefinition.dumpCause(e), e);
        }
    }

    protected void generateSecretKeyOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore, int keySize) throws OperationFailedException {
        try {
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            if (credentialStore.exists(alias, SecretKeyCredential.class)) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialAlreadyExists(alias, SecretKeyCredential.class.getName());
            }
            SecretKey secretKey = SecretKeyUtil.generateSecretKey((int)keySize);
            AbstractCredentialStoreResourceDefinition.storeSecretKey(credentialStore, alias, secretKey);
        }
        catch (GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.secretKeyOperationFailed("generate-secret-key", AbstractCredentialStoreResourceDefinition.dumpCause(e), e);
        }
    }

    protected static PasswordCredential createCredentialFromPassword(char[] password) throws UnsupportedCredentialTypeException {
        try {
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
            return new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(password)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedCredentialTypeException((Throwable)e);
        }
    }

    protected static void storeSecret(CredentialStore credentialStore, String alias, String secretValue) throws CredentialStoreException {
        char[] secret = secretValue != null ? secretValue.toCharArray() : new char[]{};
        AbstractCredentialStoreResourceDefinition.storeCredential(credentialStore, alias, (Credential)AbstractCredentialStoreResourceDefinition.createCredentialFromPassword(secret));
    }

    protected static void storeSecretKey(CredentialStore credentialStore, String alias, SecretKey secretKey) throws CredentialStoreException {
        AbstractCredentialStoreResourceDefinition.storeCredential(credentialStore, alias, (Credential)new SecretKeyCredential(secretKey));
    }

    protected static void storeCredential(CredentialStore credentialStore, String alias, Credential credential) throws CredentialStoreException {
        credentialStore.store(alias, credential);
        try {
            credentialStore.flush();
        }
        catch (CredentialStoreException e) {
            credentialStore.remove(alias, PasswordCredential.class);
            throw e;
        }
    }

    protected static String dumpCause(Throwable e) {
        StringBuffer sb = new StringBuffer().append(e.getLocalizedMessage());
        Throwable c = e.getCause();
        int depth = 0;
        while (c != null && depth++ < 10) {
            sb.append("->").append(c.getLocalizedMessage());
            c = c.getCause() == c ? null : c.getCause();
        }
        return sb.toString();
    }

    static class CredentialStoreReloadHandler
    extends ElytronRuntimeOnlyHandler {
        CredentialStoreReloadHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ExceptionFunction credentialStoreApi = (ExceptionFunction)context.getCapabilityRuntimeAPI("org.wildfly.security.credential-store-api", context.getCurrentAddressValue(), ExceptionFunction.class);
            AbstractCredentialStoreDoohickey doohickey = (AbstractCredentialStoreDoohickey)credentialStoreApi;
            try {
                doohickey.reload(context);
            }
            catch (GeneralSecurityException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReloadCredentialStore(e);
            }
        }
    }

    @FunctionalInterface
    static interface CredentialStoreRuntimeOperation {
        public void handle(OperationContext var1, ModelNode var2, CredentialStore var3) throws OperationFailedException;
    }

    protected class CredentialStoreRuntimeHandler
    extends ElytronRuntimeOnlyHandler {
        private final Map<String, CredentialStoreRuntimeOperation> definedOperations;

        protected CredentialStoreRuntimeHandler(Map<String, CredentialStoreRuntimeOperation> definedOperations) {
            this.definedOperations = definedOperations;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String operationName = operation.require("operation").asString();
            CredentialStoreRuntimeOperation operationMethod = this.definedOperations.get(operationName);
            if (operationMethod == null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidOperationName(operationName, this.getExpectedOperationNames());
            }
            CredentialStore credentialStore = this.getCredentialStore(context);
            operationMethod.handle(context, operation, credentialStore);
        }

        private String[] getExpectedOperationNames() {
            return this.definedOperations.keySet().toArray(new String[this.definedOperations.size()]);
        }

        protected CredentialStore getCredentialStore(OperationContext context) throws OperationFailedException {
            ExceptionFunction credentialStoreApi = (ExceptionFunction)context.getCapabilityRuntimeAPI("org.wildfly.security.credential-store-api", context.getCurrentAddressValue(), ExceptionFunction.class);
            return (CredentialStore)credentialStoreApi.apply((Object)context);
        }
    }

    protected static abstract class AbstractCredentialStoreDoohickey
    extends ElytronDoohickey<CredentialStore> {
        protected AbstractCredentialStoreDoohickey(PathAddress resourceAddress) {
            super(resourceAddress);
        }

        protected abstract void reload(OperationContext var1) throws GeneralSecurityException, OperationFailedException;
    }
}

